/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import greymerk.roguelike.worldgen.Cardinal;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Coord {
    private int x;
    private int y;
    private int z;

    public Coord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coord(Coord toClone) {
        this.x = toClone.x;
        this.y = toClone.y;
        this.z = toClone.z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void add(Cardinal dir, int amount) {
        switch (dir) {
            case EAST: {
                this.x += amount;
                return;
            }
            case WEST: {
                this.x -= amount;
                return;
            }
            case UP: {
                this.y += amount;
                return;
            }
            case DOWN: {
                this.y -= amount;
                return;
            }
            case NORTH: {
                this.z -= amount;
                return;
            }
            case SOUTH: {
                this.z += amount;
                return;
            }
        }
    }

    public static void correct(Coord one, Coord two) {
        int temp;
        if (two.x < one.x) {
            temp = two.x;
            two.x = one.x;
            one.x = temp;
        }
        if (two.y < one.y) {
            temp = two.y;
            two.y = one.y;
            one.y = temp;
        }
        if (two.z < one.z) {
            temp = two.z;
            two.z = one.z;
            one.z = temp;
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append(this.x).append(this.y).append(this.z).toHashCode();
    }
}

