/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.worldgen.BlockFactory;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;

public class BlockFactoryCheckers
implements IBlockFactory {
    private IBlockFactory fillOne;
    private IBlockFactory fillTwo;

    public BlockFactoryCheckers(IBlockFactory fillOne, IBlockFactory fillTwo) {
        this.fillOne = fillOne;
        this.fillTwo = fillTwo;
    }

    public BlockFactoryCheckers(JsonElement json) throws Exception {
        JsonArray arr = (JsonArray)json;
        ArrayList<IBlockFactory> blocks = new ArrayList<IBlockFactory>();
        for (JsonElement entry : arr) {
            JsonObject d = entry.getAsJsonObject();
            String type = d.get("type").getAsString();
            JsonElement blockJson = d.get("data");
            blocks.add(BlockFactory.create(type, blockJson));
        }
        this.fillOne = (IBlockFactory)blocks.get(0);
        this.fillTwo = (IBlockFactory)blocks.get(1);
    }

    @Override
    public void setBlock(World world, Random rand, int x, int y, int z) {
        this.setBlock(world, rand, x, y, z, true, true);
    }

    @Override
    public void setBlock(World world, Random rand, int x, int y, int z, boolean fillAir, boolean replaceSolid) {
        if (x % 2 == 0) {
            if (z % 2 == 0) {
                if (y % 2 == 0) {
                    WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillOne, fillAir, replaceSolid);
                } else {
                    WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillTwo, fillAir, replaceSolid);
                }
            } else if (y % 2 == 0) {
                WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillTwo, fillAir, replaceSolid);
            } else {
                WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillOne, fillAir, replaceSolid);
            }
        } else if (z % 2 == 0) {
            if (y % 2 == 0) {
                WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillTwo, fillAir, replaceSolid);
            } else {
                WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillOne, fillAir, replaceSolid);
            }
        } else if (y % 2 == 0) {
            WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillOne, fillAir, replaceSolid);
        } else {
            WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillTwo, fillAir, replaceSolid);
        }
    }
}

