/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.treasure.loot.CustomLoot;
import greymerk.roguelike.treasure.loot.LootProvider;
import greymerk.roguelike.treasure.loot.Slot;
import greymerk.roguelike.treasure.loot.provider.ItemArmour;
import greymerk.roguelike.treasure.loot.provider.ItemBlock;
import greymerk.roguelike.treasure.loot.provider.ItemEnchBonus;
import greymerk.roguelike.treasure.loot.provider.ItemEnchBook;
import greymerk.roguelike.treasure.loot.provider.ItemFood;
import greymerk.roguelike.treasure.loot.provider.ItemJunk;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import greymerk.roguelike.treasure.loot.provider.ItemOre;
import greymerk.roguelike.treasure.loot.provider.ItemPotion;
import greymerk.roguelike.treasure.loot.provider.ItemRecord;
import greymerk.roguelike.treasure.loot.provider.ItemSmithy;
import greymerk.roguelike.treasure.loot.provider.ItemSupply;
import greymerk.roguelike.treasure.loot.provider.ItemTool;
import greymerk.roguelike.treasure.loot.provider.ItemWeapon;
import greymerk.roguelike.util.IWeighted;
import greymerk.roguelike.util.TextFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public enum Loot {
    WEAPON,
    ARMOUR,
    BLOCK,
    JUNK,
    ORE,
    TOOL,
    POTION,
    FOOD,
    ENCHANTBOOK,
    ENCHANTBONUS,
    SUPPLY,
    MUSIC,
    SMITHY;

    private static final int NUM_LEVELS = 5;
    private static Map<String, LootProvider> loot;

    public static void init() {
        for (Loot type : Loot.values()) {
            LootProvider loots = new LootProvider();
            loot.put(type.name(), loots);
            block16: for (int i = 0; i < 5; ++i) {
                switch (type) {
                    case WEAPON: {
                        loots.add(i, new ItemWeapon(1000, i));
                        continue block16;
                    }
                    case ARMOUR: {
                        loots.add(i, new ItemArmour(1000, i));
                        continue block16;
                    }
                    case BLOCK: {
                        loots.add(i, new ItemBlock(1000, i));
                        continue block16;
                    }
                    case JUNK: {
                        loots.add(i, new ItemJunk(1000, i));
                        continue block16;
                    }
                    case ORE: {
                        loots.add(i, new ItemOre(1000, i));
                        continue block16;
                    }
                    case TOOL: {
                        loots.add(i, new ItemTool(1000, i));
                        continue block16;
                    }
                    case POTION: {
                        loots.add(i, new ItemPotion(1000, i));
                        continue block16;
                    }
                    case FOOD: {
                        loots.add(i, new ItemFood(1000, i));
                        continue block16;
                    }
                    case ENCHANTBOOK: {
                        loots.add(i, new ItemEnchBook(1000, i));
                        continue block16;
                    }
                    case ENCHANTBONUS: {
                        loots.add(i, new ItemEnchBonus(1000, i));
                        continue block16;
                    }
                    case SUPPLY: {
                        loots.add(i, new ItemSupply(1000, i));
                        continue block16;
                    }
                    case MUSIC: {
                        loots.add(i, new ItemRecord(1000, i));
                        continue block16;
                    }
                    case SMITHY: {
                        loots.add(i, new ItemSmithy(1000, i));
                        continue block16;
                    }
                }
            }
        }
        CustomLoot.parseLoot();
    }

    public static void clear(Loot type) {
        LootProvider lootp = loot.get(type.name());
        lootp.clear();
    }

    public static void addAllLevels(Loot type, IWeighted toAdd) {
        LootProvider lootp = loot.get(type.name());
        lootp.addAllLevels(toAdd);
    }

    public static void add(Loot type, IWeighted toAdd, int level) {
        LootProvider lootp = loot.get(type.name());
        lootp.add(level, toAdd);
    }

    public static ItemStack getLoot(Loot type, Random rand, int level) {
        LootProvider p = loot.get(type.name());
        return p.get(rand, level);
    }

    public static ItemStack getEquipmentBySlot(Random rand, Slot slot, int level, boolean enchant) {
        if (slot == Slot.WEAPON) {
            return ItemWeapon.getRandom(rand, level, enchant);
        }
        return ItemArmour.getRandom(rand, level, slot, enchant);
    }

    public static ItemStack getSupplyItem(Random rand, int level) {
        if (rand.nextInt(500) == 0) {
            ItemNovelty[] items = new ItemNovelty[]{ItemNovelty.GUUDE, ItemNovelty.JOHNNYRAGGOT, ItemNovelty.FOURLES};
            return ItemNovelty.getItem(items[rand.nextInt(items.length)]);
        }
        if (rand.nextInt(10) == 0) {
            return ItemBlock.getRandom(rand, level);
        }
        return Loot.pickSupplyItem(rand);
    }

    private static ItemStack pickSupplyItem(Random rand) {
        if (rand.nextInt(20) == 0) {
            return new ItemStack(Items.field_151172_bF, 1);
        }
        if (rand.nextInt(20) == 0) {
            return new ItemStack(Items.field_151174_bG, 1);
        }
        switch (rand.nextInt(8)) {
            case 0: {
                return new ItemStack(Items.field_151014_N, rand.nextInt(8) + 1);
            }
            case 1: {
                return new ItemStack(Items.field_151080_bb, rand.nextInt(8) + 1);
            }
            case 2: {
                return new ItemStack(Items.field_151081_bc, rand.nextInt(8) + 1);
            }
            case 3: {
                return new ItemStack(Items.field_151015_O, rand.nextInt(8) + 1);
            }
            case 4: {
                return new ItemStack(Blocks.field_150478_aa, 10 + rand.nextInt(10));
            }
            case 5: {
                return new ItemStack(Items.field_151121_aF, rand.nextInt(8) + 1);
            }
            case 6: {
                return new ItemStack(Items.field_151122_aG, rand.nextInt(4) + 1);
            }
            case 7: {
                return new ItemStack(Blocks.field_150345_g, rand.nextInt(4) + 1, rand.nextInt(4));
            }
        }
        return new ItemStack(Items.field_151055_y, 1);
    }

    public static int getEnchantLevel(Random rand, int level) {
        switch (level) {
            case 4: {
                return 21 + rand.nextInt(10);
            }
            case 3: {
                return 16 + rand.nextInt(10);
            }
            case 2: {
                return 5 + rand.nextInt(10);
            }
            case 1: {
                return 1 + rand.nextInt(5);
            }
            case 0: {
                return 1;
            }
        }
        return 1;
    }

    public static void enchantItemChance(ItemStack item, Random rand, int level) {
        if (rand.nextInt(7 - level) == 0) {
            Loot.enchantItem(item, rand, Loot.getEnchantLevel(rand, level));
        }
    }

    public static void enchantItem(ItemStack item, Random rand, int level) {
        boolean isBook;
        int enchantLevel = Loot.getEnchantLevel(rand, level);
        if (item == null) {
            return;
        }
        List ench = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)item, (int)enchantLevel);
        boolean bl = isBook = item.func_77973_b() == Items.field_151122_aG;
        if (isBook) {
            item.func_150996_a((Item)Items.field_151134_bR);
        }
        int var6 = isBook && ench.size() > 1 ? rand.nextInt(ench.size()) : -1;
        for (int i = 0; i < ench.size(); ++i) {
            EnchantmentData var8 = (EnchantmentData)ench.get(i);
            if (isBook && i == var6) continue;
            if (isBook) {
                Items.field_151134_bR.func_92115_a(item, var8);
                continue;
            }
            item.func_77966_a(var8.field_76302_b, var8.field_76303_c);
        }
    }

    public static void setItemLore(ItemStack item, String loreText) {
        NBTTagCompound display;
        if (item.field_77990_d == null) {
            item.field_77990_d.func_74782_a("tag", (NBTBase)new NBTTagCompound());
        }
        if (!item.field_77990_d.func_74764_b("display")) {
            item.field_77990_d.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        if (!(display = item.field_77990_d.func_74775_l("display")).func_74764_b("Lore")) {
            display.func_74782_a("Lore", (NBTBase)new NBTTagList());
        }
        NBTTagList lore = display.func_150295_c("Lore", 0);
        NBTTagString toAdd = new NBTTagString(loreText);
        lore.func_74742_a((NBTBase)toAdd);
        display.func_74782_a("Lore", (NBTBase)lore);
    }

    public static void setItemLore(ItemStack item, String loreText, TextFormat option) {
        Loot.setItemLore(item, TextFormat.apply(loreText, option));
    }

    public static void setItemName(ItemStack item, String name, TextFormat option) {
        if (option == null) {
            item.func_151001_c(name);
            return;
        }
        item.func_151001_c(TextFormat.apply(name, option));
    }

    public static void setItemName(ItemStack item, String name) {
        Loot.setItemName(item, name, null);
    }

    public static void addEquipment(World world, int rank, Entity mob) {
        boolean enchant;
        Random rand = world.field_73012_v;
        EnumDifficulty difficulty = world.field_73013_u;
        switch (difficulty) {
            case EASY: {
                enchant = rand.nextInt(5) == 0;
                break;
            }
            case NORMAL: {
                enchant = rank == 3 || rand.nextBoolean();
                break;
            }
            case HARD: {
                enchant = true;
                break;
            }
            default: {
                enchant = true;
            }
        }
        if (mob instanceof EntityZombie) {
            ItemStack weapon = ((EntityZombie)mob).func_70631_g_() && enchant && rand.nextInt(100) == 0 ? ItemNovelty.getItem(ItemNovelty.ASHLEA) : (rand.nextInt(5) == 0 ? ItemWeapon.getSword(rand, rank, enchant) : ItemTool.getRandom(rand, rank, enchant));
            mob.func_70062_b(0, weapon);
        }
        if (mob instanceof EntitySkeleton) {
            if (rand.nextInt(10) == 0 && rank > 1) {
                ((EntitySkeleton)mob).func_82201_a(1);
                mob.func_70062_b(0, ItemWeapon.getSword(rand, rank, enchant));
            } else if (rand.nextInt(20) == 0) {
                mob.func_70062_b(0, ItemWeapon.getSword(rand, rank, enchant));
            } else {
                mob.func_70062_b(0, ItemWeapon.getBow(rand, rank, enchant));
            }
        }
        for (int i = 1; i < 5; ++i) {
            if (!enchant) continue;
            ItemStack item = Loot.getEquipmentBySlot(rand, Slot.getSlotByNumber(i), rank, enchant);
            mob.func_70062_b(i, item);
        }
        for (int s = 0; s < 5; ++s) {
            ((EntityLiving)mob).func_96120_a(s, (float)RogueConfig.getDouble(RogueConfig.LOOTING));
        }
    }

    static {
        loot = new HashMap<String, LootProvider>();
        Loot.init();
    }
}

