/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure;

import greymerk.roguelike.catacomb.Catacomb;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.treasure.ITreasureChest;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;

public abstract class TreasureChestBase
implements ITreasureChest,
Iterable {
    protected World world;
    protected Random rand;
    protected int posX;
    protected int posY;
    protected int posZ;
    protected TileEntityChest chest;
    private static final int CHEST_MAX = 27;
    private List<InventorySlot> slots = new ArrayList<InventorySlot>();

    public TreasureChestBase() {
        for (int i = 0; i < 27; ++i) {
            this.slots.add(new InventorySlot(i, this));
        }
    }

    @Override
    public ITreasureChest generate(World world, Random rand, int posX, int posY, int posZ, int level, boolean trapped) {
        Block type;
        this.world = world;
        this.rand = rand;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        Collections.shuffle(this.slots, rand);
        Object object = type = trapped ? Blocks.field_150447_bR : Blocks.field_150486_ae;
        if (!WorldGenPrimitive.setBlock(world, posX, posY, posZ, type)) {
            return null;
        }
        this.chest = (TileEntityChest)world.func_147438_o(posX, posY, posZ);
        try {
            this.fillChest(this.chest, level);
            int amount = RogueConfig.getBoolean(RogueConfig.GENEROUS) ? 12 : 6;
            Iterator slots = this.iterator();
            while (slots.hasNext() && amount > 0) {
                InventorySlot slot = (InventorySlot)slots.next();
                if (!slot.empty()) continue;
                slot.set(Loot.getLoot(Loot.JUNK, rand, level));
                --amount;
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return this;
    }

    @Override
    public ITreasureChest generate(World world, Random rand, int posX, int posY, int posZ) {
        return this.generate(world, rand, posX, posY, posZ, Catacomb.getLevel(posY), false);
    }

    @Override
    public boolean setInventorySlot(ItemStack item, int slot) {
        try {
            this.chest.func_70299_a(slot, item);
            return true;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public boolean slotEmpty(int slot) {
        return this.chest.func_70301_a(slot) == null;
    }

    @Override
    public int getInventorySize() {
        if (this.chest == null) {
            return 1;
        }
        try {
            return this.chest.func_70302_i_();
        }
        catch (NullPointerException e) {
            return 1;
        }
    }

    public Iterator iterator() {
        return this.slots.iterator();
    }

    protected abstract void fillChest(TileEntityChest var1, int var2);

    protected class InventorySlot {
        int slot;
        ITreasureChest chest;

        public InventorySlot(int index, ITreasureChest chest) {
            this.slot = index;
            this.chest = chest;
        }

        public void set(ItemStack item) {
            this.chest.setInventorySlot(item, this.slot);
        }

        public boolean empty() {
            return this.chest.slotEmpty(this.slot);
        }
    }
}

