/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.segment.part;

import greymerk.roguelike.catacomb.segment.part.SegmentBase;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import net.minecraft.init.Blocks;

public class SegmentNetherLava
extends SegmentBase {
    @Override
    protected void genWall(Cardinal dir) {
        MetaBlock step = this.theme.getSecondaryStair();
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        MetaBlock lava = new MetaBlock(Blocks.field_150353_l);
        Coord cursor = new Coord(this.x, this.y, this.z);
        cursor.add(dir, 2);
        air.setBlock(this.world, cursor);
        cursor.add(Cardinal.UP, 1);
        air.setBlock(this.world, cursor);
        cursor = new Coord(this.x, this.y, this.z);
        cursor.add(dir, 5);
        boolean isAir = this.world.func_147437_c(cursor.getX(), cursor.getY(), cursor.getZ());
        boolean isLava = true;
        IBlockFactory wall = this.theme.getSecondaryWall();
        for (Cardinal orth : Cardinal.getOrthogonal(dir)) {
            Coord start = new Coord(this.x, this.y, this.z);
            start.add(dir, 3);
            Coord end = new Coord(start);
            start.add(orth, 1);
            start.add(Cardinal.UP, 2);
            end.add(Cardinal.DOWN, 1);
            if (isLava && !isAir) {
                WorldGenPrimitive.fillRectSolid(this.world, this.rand, start, end, air, true, true);
                lava.setBlock(this.world, start);
                start.add(Cardinal.reverse(orth), 1);
                lava.setBlock(this.world, start);
            }
            cursor = new Coord(this.x, this.y, this.z);
            cursor.add(dir, 2);
            step.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.reverse(orth), false));
            cursor.add(orth, 1);
            WorldGenPrimitive.setBlock(this.world, this.rand, cursor, step, true, true);
            step.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.reverse(orth), true));
            cursor.add(Cardinal.UP, 1);
            WorldGenPrimitive.setBlock(this.world, this.rand, cursor, step, true, true);
            cursor.add(Cardinal.UP, 1);
            WorldGenPrimitive.setBlock(this.world, this.rand, cursor, wall, true, true);
            cursor.add(Cardinal.reverse(orth), 1);
            WorldGenPrimitive.setBlock(this.world, this.rand, cursor, wall, true, true);
        }
    }
}

