/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Log;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonsWood
implements IDungeon {
    private static final int HEIGHT = 3;
    private static final int WIDTH = 2;
    private static final int LENGTH = 3;
    private static final int NUM_CHESTS = 2;
    private int originX;
    private int originY;
    private int originZ;
    private int woodType;

    @Override
    public boolean generate(World inWorld, Random inRandom, ITheme theme, int inOriginX, int inOriginY, int inOriginZ) {
        this.originX = inOriginX;
        this.originY = inOriginY;
        this.originZ = inOriginZ;
        this.woodType = inRandom.nextInt(6);
        Log type = Log.values()[inRandom.nextInt(Log.values().length)];
        MetaBlock pillar = Log.getLog(type);
        MetaBlock glowstone = new MetaBlock(Blocks.field_150426_aN);
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        MetaBlock planks = new MetaBlock(Blocks.field_150344_f, this.woodType);
        WorldGenPrimitive.fillRectSolid(inWorld, inRandom, this.originX - 2, this.originY, this.originZ - 3, this.originX + 2, this.originY + 3, this.originZ + 3, air);
        WorldGenPrimitive.fillRectHollow(inWorld, inRandom, this.originX - 2 - 1, this.originY - 1, this.originZ - 3 - 1, this.originX + 2 + 1, this.originY + 3 + 1, this.originZ + 3 + 1, planks, false, true);
        WorldGenPrimitive.fillRectSolid(inWorld, inRandom, this.originX - 2, this.originY, this.originZ - 3, this.originX - 2, this.originY + 3, this.originZ - 3, pillar, true, true);
        WorldGenPrimitive.fillRectSolid(inWorld, inRandom, this.originX - 2, this.originY, this.originZ + 3, this.originX - 2, this.originY + 3, this.originZ + 3, pillar, true, true);
        WorldGenPrimitive.fillRectSolid(inWorld, inRandom, this.originX + 2, this.originY, this.originZ - 3, this.originX + 2, this.originY + 3, this.originZ - 3, pillar, true, true);
        WorldGenPrimitive.fillRectSolid(inWorld, inRandom, this.originX + 2, this.originY, this.originZ + 3, this.originX + 2, this.originY + 3, this.originZ + 3, pillar, true, true);
        WorldGenPrimitive.setBlock(inWorld, this.originX - 2 + 1, this.originY - 1, this.originZ - 3 + 1, glowstone);
        WorldGenPrimitive.setBlock(inWorld, this.originX - 2 + 1, this.originY - 1, this.originZ + 3 - 1, glowstone);
        WorldGenPrimitive.setBlock(inWorld, this.originX + 2 - 1, this.originY - 1, this.originZ - 3 + 1, glowstone);
        WorldGenPrimitive.setBlock(inWorld, this.originX + 2 - 1, this.originY - 1, this.originZ + 3 - 1, glowstone);
        WorldGenPrimitive.setBlock(inWorld, inRandom, this.originX, this.originY, this.originZ, planks, true, true);
        WorldGenPrimitive.setBlock(inWorld, this.originX, this.originY + 1, this.originZ, Blocks.field_150414_aQ);
        ArrayList<Coord> space = new ArrayList<Coord>();
        space.add(new Coord(this.originX - 2, this.originY, this.originZ - 3 + 1));
        space.add(new Coord(this.originX - 2, this.originY, this.originZ + 3 - 1));
        space.add(new Coord(this.originX + 2, this.originY, this.originZ - 3 + 1));
        space.add(new Coord(this.originX + 2, this.originY, this.originZ + 3 - 1));
        TreasureChest.generate(inWorld, inRandom, space, TreasureChest.FOOD);
        return true;
    }

    @Override
    public int getSize() {
        return 6;
    }
}

