/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.worldgen.BlockJumble;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonsNetherBrickFortress
implements IDungeon {
    World world;
    Random rand;
    int originX;
    int originY;
    int originZ;
    Spawner spawner;

    @Override
    public boolean generate(World inWorld, Random inRandom, ITheme theme, int inOriginX, int inOriginY, int inOriginZ) {
        this.world = inWorld;
        this.rand = inRandom;
        this.originX = inOriginX;
        this.originY = inOriginY;
        this.originZ = inOriginZ;
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX - 5, this.originY, this.originZ - 5, this.originX + 5, this.originY + 3, this.originZ + 5, air);
        this.buildWalls();
        this.buildFloor();
        this.buildRoof();
        ArrayList<TreasureChest> types = new ArrayList<TreasureChest>(Arrays.asList(TreasureChest.WEAPONS));
        TreasureChest.createChests(this.world, this.rand, 2, WorldGenPrimitive.getRectSolid(this.originX - 6, this.originY, this.originZ - 6, this.originX + 6, this.originY, this.originZ + 6), types);
        return true;
    }

    public boolean isValidDungeonLocation(World world, int originX, int originY, int originZ) {
        return false;
    }

    protected void buildRoof() {
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX - 6, this.originY + 4, this.originZ - 6, this.originX + 6, this.originY + 6, this.originZ + 6, new MetaBlock(Blocks.field_150385_bj));
        List<Coord> lavaArea = WorldGenPrimitive.getRectSolid(this.originX - 3, this.originY + 6, this.originZ - 3, this.originX + 3, this.originY + 6, this.originZ + 3);
        for (Coord block : lavaArea) {
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            if (!this.rand.nextBoolean()) continue;
            WorldGenPrimitive.setBlock(this.world, x, y, z, Blocks.field_150353_l);
        }
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX - 3, this.originY + 4, this.originZ - 3, this.originX + 3, this.originY + 4, this.originZ + 3, air);
        BlockJumble fenceRandom = new BlockJumble();
        fenceRandom.addBlock(new MetaBlock(Blocks.field_150385_bj));
        fenceRandom.addBlock(new MetaBlock(Blocks.field_150386_bk));
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX - 5, this.originY + 4, this.originZ - 3, this.originX - 4, this.originY + 4, this.originZ + 3, fenceRandom);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX + 4, this.originY + 4, this.originZ - 3, this.originX + 5, this.originY + 4, this.originZ + 3, fenceRandom);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX - 3, this.originY + 4, this.originZ - 5, this.originX + 3, this.originY + 4, this.originZ - 4, fenceRandom);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX - 3, this.originY + 4, this.originZ + 4, this.originX + 3, this.originY + 4, this.originZ + 5, fenceRandom);
    }

    protected void buildWalls() {
        List<Coord> outerWall = WorldGenPrimitive.getRectHollow(this.originX - 6, this.originY - 1, this.originZ - 6, this.originX + 6, this.originY + 5, this.originZ + 6);
        for (Coord block : outerWall) {
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            if (y < this.originY || y > this.originY + 4) continue;
            WorldGenPrimitive.setBlock(this.world, this.rand, x, y, z, new MetaBlock(Blocks.field_150385_bj), false, true);
        }
        List<Coord> arch1 = WorldGenPrimitive.getRectSolid(this.originX - 5, this.originY, this.originZ - 5, this.originX - 4, this.originY + 4, this.originZ - 4);
        List<Coord> arch2 = WorldGenPrimitive.getRectSolid(this.originX - 5, this.originY, this.originZ + 4, this.originX - 4, this.originY + 4, this.originZ + 5);
        List<Coord> arch3 = WorldGenPrimitive.getRectSolid(this.originX + 4, this.originY, this.originZ - 5, this.originX + 5, this.originY + 4, this.originZ - 4);
        List<Coord> arch4 = WorldGenPrimitive.getRectSolid(this.originX + 4, this.originY, this.originZ + 4, this.originX + 5, this.originY + 4, this.originZ + 5);
        HashSet<Coord> pillars = new HashSet<Coord>();
        pillars.addAll(arch1);
        pillars.addAll(arch2);
        pillars.addAll(arch3);
        pillars.addAll(arch4);
        for (Coord block : pillars) {
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            if (this.rand.nextInt(15) == 0) {
                Spawner type = this.pickMobSpawner(this.rand);
                Spawner.generate(this.world, this.rand, x, y, z, type);
                continue;
            }
            WorldGenPrimitive.setBlock(this.world, x, y, z, Blocks.field_150385_bj);
        }
    }

    protected void buildFloor() {
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX - 6, this.originY - 4, this.originZ - 6, this.originX + 6, this.originY - 1, this.originZ + 6, new MetaBlock(Blocks.field_150385_bj));
        List<Coord> soulSand = WorldGenPrimitive.getRectSolid(this.originX - 5, this.originY - 1, this.originZ - 5, this.originX + 5, this.originY - 1, this.originZ + 5);
        MetaBlock sand = new MetaBlock(Blocks.field_150425_aM);
        MetaBlock wart = new MetaBlock(Blocks.field_150388_bm);
        for (Coord block : soulSand) {
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            if (!this.rand.nextBoolean() || !this.world.func_147437_c(x, y + 1, z)) continue;
            WorldGenPrimitive.setBlock(this.world, x, y, z, sand);
            if (!this.rand.nextBoolean()) continue;
            WorldGenPrimitive.setBlock(this.world, x, y + 1, z, wart);
        }
    }

    protected Spawner pickMobSpawner(Random random) {
        if (this.rand.nextInt(10) == 0) {
            return Spawner.CAVESPIDER;
        }
        if (this.rand.nextInt(5) == 0) {
            return Spawner.CREEPER;
        }
        int choice = random.nextInt(3);
        switch (choice) {
            case 0: {
                return Spawner.SKELETON;
            }
            case 1: {
                return Spawner.BLAZE;
            }
            case 2: {
                return Spawner.ZOMBIE;
            }
        }
        return Spawner.ZOMBIE;
    }

    @Override
    public int getSize() {
        return 8;
    }
}

