/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.Catacomb;
import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonsCreeperDen
implements IDungeon {
    World world;
    Random rand;
    int originX;
    int originY;
    int originZ;
    byte dungeonHeight = (byte)3;
    int dungeonLength = 2;
    int dungeonWidth = 2;
    int woolColor;
    int numChests = 2;
    MetaBlock floorBlock;
    MetaBlock wallBlock;

    @Override
    public boolean generate(World inWorld, Random inRandom, ITheme theme, int inOriginX, int inOriginY, int inOriginZ) {
        this.world = inWorld;
        this.rand = inRandom;
        this.originX = inOriginX;
        this.originY = inOriginY;
        this.originZ = inOriginZ;
        this.floorBlock = new MetaBlock(Blocks.field_150351_n);
        this.wallBlock = new MetaBlock(Blocks.field_150341_Y);
        this.buildWalls();
        this.buildFloor();
        this.buildRoof();
        this.placeMobSpawner();
        this.createChests(this.numChests);
        return true;
    }

    public boolean isValidDungeonLocation(World world, int originX, int originY, int originZ) {
        int dungeonClearance = 0;
        for (int x = originX - this.dungeonLength - 1; x <= originX + this.dungeonLength + 1; ++x) {
            for (int y = originY - 1; y <= originY + this.dungeonHeight + 1; ++y) {
                for (int z = originZ - this.dungeonWidth - 1; z <= originZ + this.dungeonWidth + 1; ++z) {
                    Material material = world.func_147439_a(x, y, z).func_149688_o();
                    if (y == originY - 1 && !material.func_76220_a()) {
                        return false;
                    }
                    if (y == originY + this.dungeonHeight + 1 && !material.func_76220_a()) {
                        return false;
                    }
                    if (x != originX - this.dungeonLength - 1 && x != originX + this.dungeonLength + 1 && z != originZ - this.dungeonWidth - 1 && z != originZ + this.dungeonWidth + 1 || y != originY || !world.func_147437_c(x, y, z) || !world.func_147437_c(x, y + 1, z)) continue;
                    ++dungeonClearance;
                }
            }
        }
        return dungeonClearance >= 1 && dungeonClearance <= 5;
    }

    protected void buildWalls() {
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockY = this.originY + this.dungeonHeight; blockY >= this.originY - 3; --blockY) {
                for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                    if (blockX == this.originX - this.dungeonLength - 1 || blockZ == this.originZ - this.dungeonWidth - 1 || blockX == this.originX + this.dungeonLength + 1 || blockZ == this.originZ + this.dungeonWidth + 1) {
                        if (blockY >= 0 && !this.world.func_147439_a(blockX, blockY - 1, blockZ).func_149688_o().func_76220_a()) {
                            WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, Blocks.field_150350_a);
                            continue;
                        }
                        if (!this.world.func_147439_a(blockX, blockY, blockZ).func_149688_o().func_76220_a()) continue;
                        int mossyChance = 2 * (1 + (blockY - this.originY));
                        if (mossyChance < 2) {
                            mossyChance = 2;
                        }
                        if (this.rand.nextInt(mossyChance) == 0) {
                            WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, this.floorBlock);
                            continue;
                        }
                        WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, this.wallBlock);
                        continue;
                    }
                    WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, Blocks.field_150350_a);
                }
            }
        }
    }

    protected void buildFloor() {
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                for (int blockY = this.originY - 1; blockY > this.originY - 4; --blockY) {
                    if (blockY < this.originY - 1 && this.rand.nextInt(12) == 0) {
                        WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, Blocks.field_150335_W);
                        continue;
                    }
                    if (this.rand.nextBoolean()) {
                        WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, this.floorBlock);
                        continue;
                    }
                    WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, this.wallBlock);
                }
            }
        }
    }

    protected void buildRoof() {
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                WorldGenPrimitive.setBlock(this.world, blockX, this.originY + this.dungeonHeight + 1, blockZ, this.wallBlock);
            }
        }
    }

    protected void createChests(int numChests) {
        block0: for (int chestCount = 0; chestCount < numChests; ++chestCount) {
            for (int attempts = 0; attempts < 3; ++attempts) {
                int chestPosZ;
                int chestPosY;
                int chestPosX = this.originX + this.rand.nextInt(this.dungeonLength * 2 + 1) - this.dungeonLength;
                if (!TreasureChest.isValidChestSpace(this.world, chestPosX, chestPosY = this.originY, chestPosZ = this.originZ + this.rand.nextInt(this.dungeonWidth * 2 + 1) - this.dungeonWidth)) continue;
                TreasureChest.generate(this.world, this.rand, chestPosX, chestPosY, chestPosZ, Catacomb.getLevel(chestPosY), true);
                if (!this.rand.nextBoolean()) continue block0;
                WorldGenPrimitive.setBlock(this.world, chestPosX, chestPosY - 2, chestPosZ, Blocks.field_150335_W);
                continue block0;
            }
        }
    }

    protected void placeMobSpawner() {
        Spawner.generate(this.world, this.rand, this.originX, this.originY, this.originZ, Spawner.CREEPER);
    }

    @Override
    public int getSize() {
        return 6;
    }
}

