/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;

public enum Spawner {
    CREEPER,
    CAVESPIDER,
    SPIDER,
    SKELETON,
    ZOMBIE,
    SILVERFISH,
    ENDERMAN,
    WITCH,
    WITHERBOSS,
    BAT,
    LAVASLIME,
    BLAZE,
    SLIME,
    PRIMEDTNT,
    PIGZOMBIE;

    private static final Spawner[] common;

    public static void generate(World world, Random rand, int posX, int posY, int posZ) {
        Spawner type = common[rand.nextInt(common.length)];
        Spawner.generate(world, rand, posX, posY, posZ, type);
    }

    public static void generate(World world, Random rand, Coord cursor, Spawner type) {
        Spawner.generate(world, rand, cursor.getX(), cursor.getY(), cursor.getZ(), type);
    }

    public static void generate(World world, Random rand, int posX, int posY, int posZ, Spawner type) {
        if (!WorldGenPrimitive.setBlock(world, posX, posY, posZ, Blocks.field_150474_ac)) {
            return;
        }
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_147438_o(posX, posY, posZ);
        if (spawner != null) {
            String name = Spawner.getSpawnerName(type);
            MobSpawnerBaseLogic logic = spawner.func_145881_a();
            logic.func_98272_a(name);
            Spawner.setRoguelike(logic);
        } else {
            System.err.println("Failed to fetch mob spawner entity at (" + posX + ", " + posY + ", " + posZ + ")");
        }
    }

    public static String getSpawnerName(Spawner type) {
        switch (type) {
            case CREEPER: {
                return "Creeper";
            }
            case CAVESPIDER: {
                return "CaveSpider";
            }
            case SPIDER: {
                return "Spider";
            }
            case SKELETON: {
                return "Skeleton";
            }
            case ZOMBIE: {
                return "Zombie";
            }
            case SILVERFISH: {
                return "Silverfish";
            }
            case ENDERMAN: {
                return "Enderman";
            }
            case WITCH: {
                return "Witch";
            }
            case WITHERBOSS: {
                return "WitherBoss";
            }
            case BAT: {
                return "Bat";
            }
            case LAVASLIME: {
                return "LavaSlime";
            }
            case BLAZE: {
                return "Blaze";
            }
            case SLIME: {
                return "Slime";
            }
            case PRIMEDTNT: {
                return "PrimedTnt";
            }
            case PIGZOMBIE: {
                return "PigZombie";
            }
        }
        return "pig";
    }

    private static void setRoguelike(MobSpawnerBaseLogic logic) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Type", logic.func_98276_e());
        nbt.func_74768_a("Weight", 1);
        NBTTagCompound properties = new NBTTagCompound();
        nbt.func_74782_a("Properties", (NBTBase)properties);
        NBTTagList activeEffects = new NBTTagList();
        properties.func_74782_a("ActiveEffects", (NBTBase)activeEffects);
        NBTTagCompound buff = new NBTTagCompound();
        activeEffects.func_74742_a((NBTBase)buff);
        buff.func_74774_a("Id", (byte)4);
        buff.func_74774_a("Amplifier", (byte)1);
        buff.func_74768_a("Duration", 10);
        buff.func_74774_a("Ambient", (byte)0);
        MobSpawnerBaseLogic mobSpawnerBaseLogic = logic;
        mobSpawnerBaseLogic.getClass();
        MobSpawnerBaseLogic.WeightedRandomMinecart cart = new MobSpawnerBaseLogic.WeightedRandomMinecart(mobSpawnerBaseLogic, nbt);
        logic.func_98277_a(cart);
        logic.func_98278_g();
    }

    static {
        common = new Spawner[]{SPIDER, SKELETON, ZOMBIE};
    }
}

