/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import com.google.gson.JsonObject;
import greymerk.roguelike.util.IWeighted;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class WeightedRandomLoot
implements Comparable<WeightedRandomLoot>,
IWeighted<ItemStack> {
    private Item id;
    private int damage;
    private int min;
    private int max;
    private int weight;

    public WeightedRandomLoot(Item id, int damage, int minStackSize, int maxStackSize, int weight) {
        this.id = id;
        this.damage = damage;
        this.min = minStackSize;
        this.max = maxStackSize;
        this.weight = weight;
    }

    public WeightedRandomLoot(JsonObject json) {
        this.id = Item.func_150899_d((int)json.get("id").getAsInt());
        this.damage = json.has("meta") ? json.get("meta").getAsInt() : 0;
        this.weight = json.get("weight").getAsInt();
        if (json.has("min") && json.has("max")) {
            this.min = json.get("min").getAsInt();
            this.max = json.get("max").getAsInt();
        } else {
            this.min = 1;
            this.max = 1;
        }
    }

    public WeightedRandomLoot(Item id, int damage, int weight) {
        this(id, damage, 1, 1, weight);
    }

    private int getStackSize(Random rand) {
        if (this.max == 1) {
            return 1;
        }
        return rand.nextInt(this.max - this.min) + this.min;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public ItemStack get(Random rand) {
        return new ItemStack(this.id, this.getStackSize(rand), this.damage);
    }

    @Override
    public int compareTo(WeightedRandomLoot other) {
        if (this.weight > other.weight) {
            return -1;
        }
        if (this.weight < other.weight) {
            return 1;
        }
        return 0;
    }
}

