/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.segment.part;

import greymerk.roguelike.catacomb.CatacombLevel;
import greymerk.roguelike.catacomb.segment.ISegment;
import greymerk.roguelike.catacomb.segment.part.SegmentArch;
import greymerk.roguelike.catacomb.segment.part.SegmentMossyArch;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.world.World;

public abstract class SegmentBase
implements ISegment {
    @Override
    public void generate(World world, Random rand, CatacombLevel level, Cardinal corridorDirection, ITheme theme, int x, int y, int z) {
        Cardinal[] orth;
        if (level.hasNearbyNode(x, z)) {
            return;
        }
        for (Cardinal dir : orth = Cardinal.getOrthogonal(corridorDirection)) {
            if (!this.isValidWall(world, dir, x, y, z)) continue;
            this.genWall(world, rand, dir, theme, x, y, z);
        }
        if (this instanceof SegmentArch || this instanceof SegmentMossyArch) {
            this.addSupport(world, rand, theme, x, y, z);
        }
    }

    protected abstract void genWall(World var1, Random var2, Cardinal var3, ITheme var4, int var5, int var6, int var7);

    protected boolean isValidWall(World world, Cardinal wallDirection, int x, int y, int z) {
        switch (wallDirection) {
            case NORTH: {
                if (world.func_147437_c(x - 1, y + 1, z - 2)) {
                    return false;
                }
                if (!world.func_147437_c(x + 1, y + 1, z - 2)) break;
                return false;
            }
            case SOUTH: {
                if (world.func_147437_c(x - 1, y + 1, z + 2)) {
                    return false;
                }
                if (!world.func_147437_c(x + 1, y + 1, z + 2)) break;
                return false;
            }
            case EAST: {
                if (world.func_147437_c(x + 2, y + 1, z - 1)) {
                    return false;
                }
                if (!world.func_147437_c(x + 2, y + 1, z + 1)) break;
                return false;
            }
            case WEST: {
                if (world.func_147437_c(x - 2, y + 1, z - 1)) {
                    return false;
                }
                if (!world.func_147437_c(x - 2, y + 1, z + 1)) break;
                return false;
            }
        }
        return true;
    }

    private void addSupport(World world, Random rand, ITheme theme, int x, int y, int z) {
        if (!world.func_147437_c(x, y - 2, z)) {
            return;
        }
        WorldGenPrimitive.fillDown(world, rand, x, y - 2, z, theme.getPrimaryPillar());
        MetaBlock stair = theme.getPrimaryStair();
        stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.WEST, true));
        WorldGenPrimitive.setBlock(world, x - 1, y - 2, z, stair);
        stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.EAST, true));
        WorldGenPrimitive.setBlock(world, x + 1, y - 2, z, stair);
        stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.SOUTH, true));
        WorldGenPrimitive.setBlock(world, x, y - 2, z + 1, stair);
        stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.NORTH, true));
        WorldGenPrimitive.setBlock(world, x, y - 2, z - 1, stair);
    }
}

