/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.Catacomb;
import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonsSlime
implements IDungeon {
    World world;
    Random rand;
    int originX;
    int originY;
    int originZ;
    IBlockFactory fillBlocks;
    MetaBlock liquid;

    @Override
    public boolean generate(World inWorld, Random inRandom, ITheme theme, int inOriginX, int inOriginY, int inOriginZ) {
        this.world = inWorld;
        this.rand = inRandom;
        this.originX = inOriginX;
        this.originY = inOriginY;
        this.originZ = inOriginZ;
        this.liquid = new MetaBlock(Catacomb.getLevel(this.originY) == 4 ? Blocks.field_150353_l : Blocks.field_150355_j);
        this.fillBlocks = theme.getPrimaryWall();
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX - 6, this.originY, this.originZ - 6, this.originX + 6, this.originY + 3, this.originZ + 6, air);
        WorldGenPrimitive.fillRectHollow(this.world, this.rand, this.originX - 7, this.originY - 2, this.originZ - 7, this.originX + 7, this.originY + 4, this.originZ + 7, this.fillBlocks, false, true);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX - 7, this.originY - 2, this.originZ - 7, this.originX + 7, this.originY - 1, this.originZ + 7, this.fillBlocks);
        this.pool(this.originX - 4, this.originZ - 4);
        this.pool(this.originX - 4, this.originZ + 4);
        this.pool(this.originX + 4, this.originZ - 4);
        this.pool(this.originX + 4, this.originZ + 4);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX - 1, this.originY + 3, this.originZ - 2, this.originX + 1, this.originY + 3, this.originZ - 2, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX - 1, this.originY + 3, this.originZ + 2, this.originX + 1, this.originY + 3, this.originZ + 2, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX - 2, this.originY + 3, this.originZ - 1, this.originX - 2, this.originY + 3, this.originZ + 1, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX + 2, this.originY + 3, this.originZ - 1, this.originX + 2, this.originY + 3, this.originZ + 1, this.fillBlocks);
        if (Catacomb.getLevel(this.originY) == 4) {
            Spawner.generate(this.world, this.rand, this.originX, this.originY + 5, this.originZ, Spawner.LAVASLIME);
        } else {
            WorldGenPrimitive.randomVines(this.world, this.rand, this.originX - 7, this.originY + 2, this.originZ - 7, this.originX + 7, this.originY + 5, this.originZ + 7);
        }
        return true;
    }

    private void pool(int inX, int inZ) {
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, this.originY - 1, inZ - 1, inX + 1, this.originY - 1, inZ + 1, this.liquid);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, this.originY - 1, inZ - 2, inX - 2, this.originY + 3, inZ - 2, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, this.originY - 1, inZ + 2, inX - 2, this.originY + 3, inZ + 2, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 2, this.originY - 1, inZ - 2, inX + 2, this.originY + 3, inZ - 2, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 2, this.originY - 1, inZ + 2, inX + 2, this.originY + 3, inZ + 2, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, this.originY - 1, inZ - 2, inX + 1, this.originY - 1, inZ - 2, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, this.originY - 1, inZ + 2, inX + 1, this.originY - 1, inZ + 2, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, this.originY - 1, inZ - 1, inX - 2, this.originY - 1, inZ + 1, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 2, this.originY - 1, inZ - 1, inX + 2, this.originY - 1, inZ + 1, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, this.originY + 3, inZ - 2, inX + 1, this.originY + 3, inZ - 2, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, this.originY + 3, inZ + 2, inX + 1, this.originY + 3, inZ + 2, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, this.originY + 3, inZ - 1, inX - 2, this.originY + 3, inZ + 1, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 2, this.originY + 3, inZ - 1, inX + 2, this.originY + 3, inZ + 1, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, this.originY + 1, inZ - 1, inX + 1, this.originY + 6, inZ + 1, new MetaBlock(Blocks.field_150350_a));
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, this.originY + 7, inZ - 2, inX + 2, this.originY + 8, inZ + 2, this.fillBlocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, this.originY + 8, inZ - 1, inX + 1, this.originY + 8, inZ + 1, this.liquid);
    }

    public boolean isValidDungeonLocation(World world, int originX, int originY, int originZ) {
        return false;
    }

    @Override
    public int getSize() {
        return 8;
    }
}

