/*
 * Decompiled with CFR 0.152.
 */
package goki.xpstoragechest.handlers;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import goki.xpstoragechest.tileentities.TileEntityXpStorageChest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class PacketHandler
implements IPacketHandler {
    public static final String GENERIC_NETWORK_CHANNEL = "XpStorageChest";

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player playerEntity) {
        if (packet.field_73630_a.equals(GENERIC_NETWORK_CHANNEL)) {
            this.handleGenericPacket(packet, playerEntity);
        }
    }

    private void handleGenericPacket(Packet250CustomPayload packet, Player playerEntity) {
        String type = "";
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            type = inputStream.readUTF();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (type.equals("XpStorageChestSync")) {
            this.handleBlockSyncStream(packet.field_73629_c, playerEntity);
        } else if (type.equals("syncXP")) {
            EntityPlayer player = (EntityPlayer)playerEntity;
            try {
                float percent = inputStream.readFloat();
                int level = inputStream.readInt();
                int total = inputStream.readInt();
                player.field_71106_cc = percent;
                player.field_71068_ca = level;
                player.field_71067_cb = total;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private void handleBlockSyncStream(byte[] stream, Player playerEntity) {
        int type = 0;
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(stream));
        try {
            inputStream.readUTF();
            type = inputStream.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (type == 0) {
            TileEntityXpStorageChest tileEntity;
            EntityClientPlayerMP playerMP = (EntityClientPlayerMP)playerEntity;
            int x = 0;
            int y = 0;
            int z = 0;
            int amount = -1;
            try {
                x = inputStream.readInt();
                y = inputStream.readInt();
                z = inputStream.readInt();
                amount = inputStream.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            if (playerMP.field_70170_p.field_72995_K && (tileEntity = (TileEntityXpStorageChest)playerMP.field_70170_p.func_72796_p(x, y, z)) != null) {
                tileEntity.alterExperience(amount);
                tileEntity.hasUpdated = true;
                PacketDispatcher.sendPacketToServer((Packet)PacketHandler.getXpStorageSyncPacket(1, x, y, z, 0));
            }
        } else if (type == 1) {
            TileEntityXpStorageChest tileEntity;
            EntityPlayerMP playerMP = (EntityPlayerMP)playerEntity;
            int x = 0;
            int y = 0;
            int z = 0;
            try {
                x = inputStream.readInt();
                y = inputStream.readInt();
                z = inputStream.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            if (!playerMP.field_70170_p.field_72995_K && (tileEntity = (TileEntityXpStorageChest)playerMP.field_70170_p.func_72796_p(x, y, z)) != null) {
                tileEntity.hasUpdated = true;
            }
        }
    }

    public static Packet250CustomPayload getGenericPacket(String type, byte[] additionalData) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeUTF(type);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (additionalData != null) {
            try {
                outputStream.write(additionalData);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = GENERIC_NETWORK_CHANNEL;
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        return packet;
    }

    public static Packet250CustomPayload getXpStorageSyncPacket(int type, int x, int y, int z, int amount) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(type);
            outputStream.writeInt(x);
            outputStream.writeInt(y);
            outputStream.writeInt(z);
            outputStream.writeInt(amount);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return PacketHandler.getGenericPacket("XpStorageChestSync", bos.toByteArray());
    }

    public static Packet250CustomPayload getXpSyncPacket(float experience, int experienceLevel, int experienceTotal) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(32);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeFloat(experience);
            outputStream.writeInt(experienceLevel);
            outputStream.writeInt(experienceTotal);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return PacketHandler.getGenericPacket("syncXP", bos.toByteArray());
    }

    public static Packet250CustomPayload getXpSyncPacket(EntityPlayer player) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(32);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeFloat(player.field_71106_cc);
            outputStream.writeInt(player.field_71068_ca);
            outputStream.writeInt(player.field_71067_cb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return PacketHandler.getGenericPacket("syncXP", bos.toByteArray());
    }
}

