/*
 * Decompiled with CFR 0.152.
 */
package goki.xpstoragechest.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class Helper {
    public static String[] randomStringChoices = new String[]{"Grape Drink", "Angel's Tongue", "Cobbleflint", "Jamuberry", "Gokigobs", "Golden Cockroach", "Atapiderpixerpi's Left Ear", "0xC0FFEE", "Plaid Dress Shirt", "Ramen Soup", "Rusted Shovel", "Bag of Yellow Apples", "Limited Edition GokiCraft Collectible Figurine", "Paper Towel", "Bag of Smittles", "Old Keyboard's G Key", "Strand of Mei's Hair", "Isaac's Locket", "Guide to Mining", "Lint", "Dust", "Chewed Fingernail", "Tuna", "Fat Cat", "20 Cents", "Zhor's Hammer", "Sock", "Cheese Wheel", "Slice of Cheese", "Block of Cheese", "The Golden Cheese", "Picture of a Blue Haired Girl and a Rabbit", "Forte's Gun", "Jerrybeans", "Empty Soda Can"};

    public static NBTTagCompound getPlayerPersistentNBT(EntityPlayer player) {
        NBTTagCompound nbt;
        if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
            nbt = new NBTTagCompound();
            player.getEntityData().func_74766_a("PlayerPersisted", nbt);
        }
        nbt = player.getEntityData().func_74775_l("PlayerPersisted");
        return nbt;
    }

    public static float getRatio(int minValue, int maxValue, int value) {
        if (minValue + maxValue == 0) {
            return 0.0f;
        }
        return (float)value / 1.0f / (float)(minValue + maxValue);
    }

    public static int getPositionFromRatio(int minValue, int maxValue, float ratio) {
        return Helper.floatToInt((float)(maxValue - minValue) * ratio + (float)minValue);
    }

    public static ScaledResolution getScaledResolution() {
        Minecraft mc = Minecraft.func_71410_x();
        return new ScaledResolution(mc.field_71474_y, mc.field_71443_c, mc.field_71440_d);
    }

    public static int floatToInt(float f) {
        return (int)f;
    }

    public static float trimDecimals(float in, int decimals) {
        float f = (float)((double)in * Math.pow(10.0, decimals));
        int i = (int)f;
        return (float)i / (float)Math.pow(10.0, decimals);
    }

    public static String itemIDString(ItemStack stack) {
        String id = "" + stack.field_77993_c;
        id = stack.func_77981_g() ? id + ":" + stack.func_77960_j() : id + ":0";
        return id;
    }

    public static ArrayList<EntityTameable> getPlayersPets(EntityPlayer player) {
        ArrayList<EntityTameable> aList = new ArrayList<EntityTameable>();
        World world = player.field_70170_p;
        List ents = world.func_72910_y();
        for (int i = 0; i < ents.size(); ++i) {
            EntityTameable tameable;
            Entity entity = (Entity)ents.get(i);
            if (!(entity instanceof EntityTameable) || !(tameable = (EntityTameable)entity).func_70909_n() || tameable.func_70902_q() != player) continue;
            aList.add(tameable);
        }
        return aList;
    }

    public static boolean areItemsSameType(ItemStack stack1, ItemStack stack2) {
        return !stack1.func_77981_g() && stack1.func_77981_g() == stack2.func_77981_g() ? stack1.field_77993_c == stack2.field_77993_c : stack1.func_77981_g() && stack1.func_77981_g() == stack2.func_77981_g() && stack1.field_77993_c == stack2.field_77993_c && stack1.func_77960_j() == stack2.func_77960_j();
    }

    public static boolean areItemsSameType(int id1, int id2) {
        return Helper.areItemsSameType(id1, 0, id2, 0);
    }

    public static void setPlayersExpTo(EntityPlayer player, int total) {
        player.field_71068_ca = Helper.getLevelFromXPValue(total);
        player.field_71106_cc = Helper.getCurrentFromXPValue(total);
    }

    public static int getXPTotal(int xpLevel, float current) {
        return (int)((float)Helper.getXPValueFromLevel(xpLevel) + (float)Helper.getXPValueToNextLevel(xpLevel) * current);
    }

    public static int getXPTotal(EntityPlayer player) {
        return (int)((float)Helper.getXPValueFromLevel(player.field_71068_ca) + (float)Helper.getXPValueToNextLevel(player.field_71068_ca) * player.field_71106_cc);
    }

    public static int getLevelFromXPValue(int value) {
        int level = 0;
        level = value >= Helper.getXPValueFromLevel(30) ? (int)(0.07142857142857142 * (Math.sqrt(56.0 * (double)value - 32511.0) + 303.0)) : (value >= Helper.getXPValueFromLevel(15) ? (int)(0.16666666666666666 * (Math.sqrt(24.0 * (double)value - 5159.0) + 59.0)) : (int)((double)value / 17.0));
        return level;
    }

    public static float getCurrentFromXPValue(int value) {
        if (value == 0) {
            return 0.0f;
        }
        int level = Helper.getLevelFromXPValue(value);
        int needed = Helper.getXPValueFromLevel(level);
        int next = Helper.getXPValueToNextLevel(level);
        int difference = value - needed;
        float current = (float)difference / (float)next;
        return current;
    }

    public static int getXPValueFromLevel(int xpLevel) {
        int val = 0;
        val = xpLevel >= 30 ? (int)(3.5 * Math.pow(xpLevel, 2.0) - 151.5 * (double)xpLevel + 2220.0) : (xpLevel >= 15 ? (int)(1.5 * Math.pow(xpLevel, 2.0) - 29.5 * (double)xpLevel + 360.0) : 17 * xpLevel);
        return val;
    }

    public static int getXPValueToNextLevel(int xpLevel) {
        int val = 0;
        val = xpLevel >= 30 ? 7 * xpLevel - 148 : (xpLevel >= 15 ? 3 * xpLevel - 28 : 17);
        return val;
    }

    public static boolean areItemsSameType(int id1, int dmg1, int id2, int dmg2) {
        boolean subtypes1 = Item.field_77698_e[id1].func_77614_k();
        boolean subtypes2 = Item.field_77698_e[id2].func_77614_k();
        return !subtypes1 && subtypes1 == subtypes2 ? id1 == id2 : subtypes1 && subtypes1 == subtypes2 && id1 == id2 && dmg1 == dmg2;
    }

    public static World getPlayersCurrentWorld() {
        return Minecraft.func_71410_x().field_71439_g.field_70170_p;
    }

    public static boolean isServerClient(MinecraftServer server) {
        return server != null && server.field_71305_c.length != 0;
    }

    public static Entity getEntityByID(int entityID, World world) {
        for (int i = 0; i < world.func_72910_y().size(); ++i) {
            if (((Entity)world.func_72910_y().get((int)i)).field_70157_k != entityID) continue;
            return (Entity)world.func_72910_y().get(i);
        }
        return null;
    }

    public static int getProperStringWidth(FontRenderer fontRenderer, String string) {
        if (string == null) {
            return 0;
        }
        char[] list = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int width = 0;
        boolean wide = false;
        for (int index = 0; index < string.length(); ++index) {
            int charWidth;
            int skip = 0;
            char ch = string.charAt(index);
            if (skip == 0 && ch == '\u00a7' && index + 1 < string.length()) {
                for (int i = 0; i < list.length; ++i) {
                    if (string.charAt(index + 1) != list[i]) continue;
                    skip = 2;
                    break;
                }
            }
            if ((charWidth = fontRenderer.func_78263_a(ch)) < 0 && index < string.length() - 1) {
                if ((ch = string.charAt(++index)) != 'l' && ch != 'L') {
                    if (ch == 'r' || ch == 'R') {
                        wide = false;
                    }
                } else {
                    wide = true;
                }
                charWidth = fontRenderer.func_78263_a(ch);
            }
            if (skip == 0) {
                width += charWidth;
            } else {
                --skip;
            }
            if (!wide) continue;
            ++width;
        }
        return width;
    }

    public static String getRandomString() {
        return randomStringChoices[new Random().nextInt(randomStringChoices.length)];
    }

    public static String getRandomString(long seed) {
        return randomStringChoices[new Random(seed).nextInt(randomStringChoices.length)];
    }

    public static boolean isBlockIDWithin(World world, int blockID, int x, int y, int z, int distance) {
        int h = distance / 2;
        for (int i = x - h; i < x + h; ++i) {
            for (int j = y - h; j < y + h; ++j) {
                for (int k = z - h; k < z + h; ++k) {
                    if (world.func_72798_a(i, j, k) != blockID) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean forceBlockUpdateWithin(World world, int blockID, int x, int y, int z, int distance) {
        int h = distance / 2;
        for (int i = x - h; i < x + h; ++i) {
            for (int j = y - h; j < y + h; ++j) {
                for (int k = z - h; k < z + h; ++k) {
                    world.func_72898_h(x, y, z, blockID);
                }
            }
        }
        return false;
    }

    public static int[] getBlockPositionInfrontOfRaycastedBlock(EntityPlayer player, int distance) {
        MovingObjectPosition mop = player.func_70614_a((double)distance, 1.0f);
        if (mop != null) {
            int rcx = mop.field_72311_b;
            int rcy = mop.field_72312_c;
            int rcz = mop.field_72309_d;
            switch (mop.field_72310_e) {
                case 0: {
                    break;
                }
                case 1: {
                    ++rcy;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    ++rcz;
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    ++rcx;
                }
            }
            return new int[]{--rcx, --rcy, --rcz};
        }
        return null;
    }

    public static int getPlayerSlotWithItemAndDamage(EntityPlayer player, int itemID, int metadata) {
        ItemStack[] mi = player.field_71071_by.field_70462_a;
        for (int i = 0; i < mi.length; ++i) {
            if (mi[i] == null || mi[i].field_77993_c != itemID || mi[i].func_77960_j() != metadata) continue;
            return i;
        }
        return -1;
    }

    public static boolean playerHasItemWithDamage(EntityPlayer player, int itemID, int metadata) {
        return Helper.getPlayerSlotWithItemAndDamage(player, itemID, metadata) >= 0;
    }

    public static ItemStack playerConsumeItemWithDamage(EntityPlayer player, int itemID, int metadata) {
        int slot = Helper.getPlayerSlotWithItemAndDamage(player, itemID, metadata);
        if (slot != -1) {
            return player.field_71071_by.func_70298_a(slot, 1);
        }
        return null;
    }

    public static float getDamageDealt(EntityPlayer player, Entity target, DamageSource source) {
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b().onLeftClickEntity(stack, player, target)) {
            player.func_71035_c("can't damage with this item!");
            return 0.0f;
        }
        float damage = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float bonusDamage = 0.0f;
        boolean targetIsLiving = target instanceof EntityLivingBase;
        boolean critical = false;
        if (targetIsLiving) {
            bonusDamage = EnchantmentHelper.func_77512_a((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)target));
        }
        if (damage > 0.0f || bonusDamage > 0.0f) {
            boolean bl = critical = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null && targetIsLiving;
            if (critical && damage > 0.0f) {
                damage *= 1.5f;
            }
            damage += bonusDamage;
        }
        return damage;
    }

    public static float getFallResistance(EntityLivingBase entity) {
        float resistance = 3.0f;
        PotionEffect potioneffect = entity.func_70660_b(Potion.field_76430_j);
        float bonus = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        return resistance + bonus;
    }
}

