/*
 * Decompiled with CFR 0.152.
 */
package com.ghost.render;

import com.ghost.player.ExtendedPlayerProps;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.DimensionManager;
import org.lwjgl.opengl.GL11;

public class GuiOverrider
extends Gui {
    private static final ResourceLocation texturePath = new ResourceLocation("resurrection:textures/misc/ghostBlur.png");

    @SubscribeEvent
    public void overrideGUI(RenderGameOverlayEvent event) throws IOException {
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        boolean shouldProceed = this.getData((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (shouldProceed && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            this.renderGhostBlur(event.resolution.func_78326_a(), event.resolution.func_78328_b());
        }
    }

    private boolean getData(EntityPlayer player) throws IOException {
        NBTTagCompound nbt;
        ExtendedPlayerProps cfr_ignored_0 = (ExtendedPlayerProps)player.getExtendedProperties("resurrection_properties");
        boolean playerMode = ExtendedPlayerProps.getGhostMode();
        String fileName = "Ghost.dat";
        File myFile = new File(DimensionManager.getCurrentSaveRootDirectory(), fileName);
        FileInputStream fis = new FileInputStream(myFile);
        DataInputStream instream = new DataInputStream(fis);
        try {
            nbt = CompressedStreamTools.func_74794_a((DataInput)instream);
        }
        catch (Exception e) {
            CompressedStreamTools.func_74795_b((NBTTagCompound)new NBTTagCompound(), (File)myFile);
            nbt = CompressedStreamTools.func_74794_a((DataInput)instream);
        }
        boolean worldMode = nbt.func_74764_b("isGhost") ? nbt.func_74767_n("isGhost") : false;
        instream.close();
        fis.close();
        return playerMode && worldMode;
    }

    protected void renderGhostBlur(int par1, int par2) {
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texturePath);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)par2, -90.0, 0.0, 1.0);
        tessellator.func_78374_a((double)par1, (double)par2, -90.0, 1.0, 1.0);
        tessellator.func_78374_a((double)par1, 0.0, -90.0, 1.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

