/*
 * Decompiled with CFR 0.152.
 */
package com.ghost.core;

import com.ghost.core.Main;
import com.ghost.player.ExtendedPlayerProps;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.BlockEvent;

public class EventsHandler {
    private Random random = new Random();
    private static ChunkCoordinates respawnLocation = new ChunkCoordinates(0, -1, 0);

    public static void setRespawnLocation(ChunkCoordinates location) {
        respawnLocation = location;
    }

    @SubscribeEvent
    public void mobKilled(AttackEntityEvent event) {
        int rand;
        if (event.target instanceof EntityZombie && event.entityPlayer.field_71071_by.func_146028_b(Main.soul) && (rand = new Random().nextInt(25)) == 0) {
            event.entityPlayer.field_71071_by.func_146026_a(Main.soul);
            event.entityPlayer.field_71071_by.func_70441_a(new ItemStack(Main.zombieSoul));
        }
    }

    @SubscribeEvent
    public void blockBroken(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester != null && event.block == Blocks.field_150425_aM) {
            int i = this.random.nextInt(4) < 2 ? 1 : 0;
            event.drops.add(new ItemStack(Main.soul, i));
        }
    }

    @SubscribeEvent
    public void getDeathTime(LivingHurtEvent event) throws IOException {
        if (event.entity instanceof EntityPlayer) {
            double posY;
            double posX = event.entity.field_70165_t;
            double blockY = posY = event.entity.field_70163_u;
            double posZ = event.entity.field_70161_v;
            WorldServer world = DimensionManager.getWorld((int)0);
            WorldClient worldInstance = Minecraft.func_71410_x().field_71441_e;
            if (((EntityLivingBase)event.entity).func_110143_aJ() - event.ammount <= 0.0f && worldInstance.field_73011_w.field_76574_g != 1 && event.entity.field_70163_u > -1.0 && !((EntityPlayer)event.entity).field_71075_bZ.field_75098_d) {
                ((EntityPlayer)event.entity).func_71029_a((StatBase)Main.firstGhost);
                if (worldInstance.field_73011_w.field_76574_g == 0) {
                    while (true) {
                        if (world.func_147439_a((int)posX, (int)blockY, (int)posZ) == Blocks.field_150350_a) {
                            world.func_147449_b((int)posX, (int)blockY - 1, (int)posZ, Blocks.field_150425_aM);
                            world.func_147449_b((int)posX, (int)blockY, (int)posZ, Main.woodenCross);
                            break;
                        }
                        blockY += 1.0;
                    }
                }
                if (!worldInstance.field_73011_w.field_76575_d || EventsHandler.respawnLocation.field_71572_b != -1) {
                    this.setData((EntityPlayer)event.entity);
                    boolean keepInv = this.checkForDeathChest((EntityPlayer)event.entity, (World)world);
                    if (!keepInv) {
                        ((EntityPlayer)event.entity).field_71071_by.func_70436_m();
                        ((EntityPlayer)event.entity).field_71071_by.func_70441_a(new ItemStack(Main.soul, 1));
                    }
                    EventsHandler.respawnPlayer(respawnLocation, (World)world, (World)worldInstance, (EntityPlayer)event.entity);
                    ((EntityLivingBase)event.entity).func_70691_i(((EntityLivingBase)event.entity).func_110138_aP());
                    event.setCanceled(true);
                }
            }
        }
    }

    private boolean checkForDeathChest(EntityPlayer player, World world) {
        boolean result = false;
        if (player.getBedLocation(0) == null) {
            System.err.println("bed not found");
            return result;
        }
        ChunkCoordinates bed = player.getBedLocation(0);
        List entities = world.func_72872_a(EntityHanging.class, AxisAlignedBB.func_72332_a().func_72299_a((double)(bed.field_71574_a - 5), (double)(bed.field_71572_b - 5), (double)(bed.field_71573_c - 5), (double)(bed.field_71574_a + 5), (double)(bed.field_71572_b + 5), (double)(bed.field_71573_c + 5)));
        for (Object obj : entities) {
            Item displayed;
            if (!(obj instanceof EntityItemFrame)) continue;
            System.err.println("item frame in AABB");
            if (((EntityItemFrame)obj).func_82335_i() == null || (displayed = ((EntityItemFrame)obj).func_82335_i().func_77973_b()) != Main.itemDeathChest) continue;
            result = true;
            break;
        }
        return result;
    }

    public static void respawnPlayer(ChunkCoordinates potentialSpawn, World world, World dimension, EntityPlayer player) {
        ChunkCoordinates spawn;
        if (dimension.field_73011_w.field_76575_d && potentialSpawn.field_71572_b != -1) {
            System.err.println("respawning on blaze grave");
            spawn = potentialSpawn;
        } else if (player.getBedLocation(0) != null) {
            spawn = player.getBedLocation(0);
            System.err.println("respawning at bed location");
        } else {
            spawn = world.func_72861_E();
            int blockX = spawn.field_71574_a;
            int blockZ = spawn.field_71573_c;
            int blockY = spawn.field_71572_b;
            while (world.func_147439_a(spawn.field_71574_a, blockY, spawn.field_71573_c) != Blocks.field_150350_a) {
                ++blockY;
            }
            spawn = new ChunkCoordinates(blockX, blockY, blockZ);
            System.err.println("respawning at world's spawnpoint");
        }
        System.err.println(spawn);
        player.func_70634_a((double)spawn.field_71574_a, (double)spawn.field_71572_b, (double)spawn.field_71573_c);
    }

    @SubscribeEvent
    public void playerUpdate(LivingEvent.LivingUpdateEvent event) throws IOException {
        if (event.entity instanceof EntityPlayer) {
            boolean shouldProceed = false;
            try {
                shouldProceed = this.getData((EntityPlayer)event.entity);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (shouldProceed) {
                ((EntityPlayer)event.entity).field_71075_bZ.field_75102_a = true;
                ((EntityPlayer)event.entity).field_71075_bZ.field_75099_e = false;
            }
        }
    }

    @SubscribeEvent
    public void playerPickUpEvent(EntityItemPickupEvent event) throws IOException {
        if (this.getData(event.entityPlayer)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerTossEvent(ItemTossEvent event) throws IOException {
        if (this.getData(event.player)) {
            event.player.field_71071_by.func_70441_a(new ItemStack(event.entityItem.func_92059_d().func_77973_b()));
            event.setCanceled(true);
        }
    }

    private void setData(EntityPlayer player) throws IOException {
        NBTTagCompound nbt;
        ExtendedPlayerProps cfr_ignored_0 = (ExtendedPlayerProps)player.getExtendedProperties("resurrection_properties");
        ExtendedPlayerProps.setGhostMode(true);
        String fileName = "Ghost.dat";
        File myFile = new File(DimensionManager.getCurrentSaveRootDirectory(), fileName);
        if (!myFile.isFile() && !myFile.exists()) {
            myFile.createNewFile();
        }
        FileInputStream fis = new FileInputStream(myFile);
        DataInputStream instream = new DataInputStream(fis);
        try {
            nbt = CompressedStreamTools.func_74794_a((DataInput)instream);
        }
        catch (Exception e) {
            CompressedStreamTools.func_74795_b((NBTTagCompound)new NBTTagCompound(), (File)myFile);
            nbt = CompressedStreamTools.func_74794_a((DataInput)instream);
        }
        nbt.func_74757_a("isGhost", true);
        CompressedStreamTools.func_74795_b((NBTTagCompound)nbt, (File)myFile);
        instream.close();
        fis.close();
    }

    private boolean getData(EntityPlayer player) throws IOException {
        NBTTagCompound nbt;
        ExtendedPlayerProps cfr_ignored_0 = (ExtendedPlayerProps)player.getExtendedProperties("resurrection_properties");
        boolean playerMode = ExtendedPlayerProps.getGhostMode();
        String fileName = "Ghost.dat";
        File myFile = new File(DimensionManager.getCurrentSaveRootDirectory(), fileName);
        if (!myFile.isFile() && !myFile.exists()) {
            myFile.createNewFile();
        }
        FileInputStream fis = new FileInputStream(myFile);
        DataInputStream instream = new DataInputStream(fis);
        try {
            nbt = CompressedStreamTools.func_74794_a((DataInput)instream);
        }
        catch (Exception e) {
            CompressedStreamTools.func_74795_b((NBTTagCompound)new NBTTagCompound(), (File)myFile);
            nbt = CompressedStreamTools.func_74794_a((DataInput)instream);
        }
        boolean worldMode = nbt.func_74764_b("isGhost") ? nbt.func_74767_n("isGhost") : false;
        instream.close();
        fis.close();
        return playerMode && worldMode;
    }
}

