/*
 * Decompiled with CFR 0.152.
 */
package com.ghost.core;

import com.ghost.core.EventsHandler;
import com.ghost.core.Main;
import com.ghost.player.ExtendedPlayerProps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class BlockGravestone
extends Block {
    private IIcon icon;
    private String field_149827_a;
    private String type;
    private boolean isGrave;

    protected BlockGravestone(String textureName) {
        super(Material.field_151594_q);
        this.field_149827_a = textureName;
        this.type = textureName;
        this.isGrave = false;
    }

    protected BlockGravestone(String textureName, boolean grave) {
        super(Material.field_151594_q);
        this.field_149827_a = textureName;
        this.type = textureName;
        this.isGrave = grave;
    }

    public Item func_149650_a(int i, Random rand, int j) {
        return this.type.equals("stone") ? (this.isGrave ? Main.itemStoneGrave : Main.itemStoneCross) : (this.type.equals("planks_oak") ? Main.itemWoodCross : (this.type.equals("blaze") ? Main.itemBlazeCross : (this.type.equals("cobblestone") ? (this.isGrave ? Main.itemCobbleGrave : Main.itemCobbleCross) : (this.type.equals("cobblestone_mossy") ? (this.isGrave ? Main.itemCobbleMGrave : Main.itemCobbleMCross) : null))));
    }

    public boolean func_149742_c(World world, int i, int j, int k) {
        boolean inWorld = false;
        try {
            inWorld = this.getDataFromWorld();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.type.equals("blaze")) {
            return world.field_73011_w.field_76575_d && !inWorld;
        }
        return true;
    }

    public void func_149726_b(World world, int i, int j, int k) {
        if (this.type.equals("blaze")) {
            EventsHandler.setRespawnLocation(new ChunkCoordinates(i, j, k));
            try {
                this.saveDataToWorld(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void func_149749_a(World world, int i, int j, int k, Block block, int par6) {
        if (this.type.equals("blaze")) {
            EventsHandler.setRespawnLocation(new ChunkCoordinates(0, -1, 0));
            try {
                this.saveDataToWorld(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void saveDataToWorld(boolean b) throws IOException {
        NBTTagCompound nbt;
        String fileName = "Ghost.dat";
        File myFile = new File(DimensionManager.getCurrentSaveRootDirectory(), fileName);
        if (!myFile.isFile() && !myFile.exists()) {
            myFile.createNewFile();
        }
        FileInputStream fis = new FileInputStream(myFile);
        DataInputStream instream = new DataInputStream(fis);
        try {
            nbt = CompressedStreamTools.func_74794_a((DataInput)instream);
        }
        catch (Exception e) {
            CompressedStreamTools.func_74795_b((NBTTagCompound)new NBTTagCompound(), (File)myFile);
            nbt = CompressedStreamTools.func_74794_a((DataInput)instream);
        }
        nbt.func_74757_a("blazeInWorld", b);
        CompressedStreamTools.func_74795_b((NBTTagCompound)nbt, (File)myFile);
        instream.close();
        fis.close();
    }

    private boolean getDataFromWorld() throws IOException {
        NBTTagCompound nbt;
        String fileName = "Ghost.dat";
        File myFile = new File(DimensionManager.getCurrentSaveRootDirectory(), fileName);
        if (!myFile.isFile() && !myFile.exists()) {
            myFile.createNewFile();
        }
        FileInputStream fis = new FileInputStream(myFile);
        DataInputStream instream = new DataInputStream(fis);
        try {
            nbt = CompressedStreamTools.func_74794_a((DataInput)instream);
        }
        catch (Exception e) {
            CompressedStreamTools.func_74795_b((NBTTagCompound)new NBTTagCompound(), (File)myFile);
            nbt = CompressedStreamTools.func_74794_a((DataInput)instream);
        }
        boolean worldMode = nbt.func_74764_b("blazeInWorld") ? nbt.func_74767_n("blazeInWorld") : false;
        instream.close();
        fis.close();
        return worldMode;
    }

    public int func_149738_a(World p_149738_1_) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World p_149694_1_, int p_149694_2_, int p_149694_3_, int p_149694_4_) {
        return this.type.equals("stone") ? (this.isGrave ? Main.itemStoneGrave : Main.itemStoneCross) : (this.type.equals("planks_oak") ? Main.itemWoodCross : (this.type.equals("blaze") ? Main.itemBlazeCross : (this.type.equals("cobblestone") ? (this.isGrave ? Main.itemCobbleGrave : Main.itemCobbleCross) : (this.type.equals("cobblestone_mossy") ? (this.isGrave ? Main.itemCobbleMGrave : Main.itemCobbleMCross) : null))));
    }

    public void func_149734_b(World world, int i, int j, int k, Random rand) {
        super.func_149674_a(world, i, j, k, rand);
        String particleName = this.type.equals("blaze") ? "flame" : "depthsuspend";
        world.func_72869_a(particleName, (double)i + 0.125, (double)j + 0.125, (double)k + 0.125, 0.0, 0.0, 0.0);
        world.func_72869_a(particleName, (double)i + 0.875, (double)j + 0.125, (double)k + 0.125, 0.0, 0.0, 0.0);
        world.func_72869_a(particleName, (double)i + 0.125, (double)j + 0.125, (double)k + 0.875, 0.0, 0.0, 0.0);
        world.func_72869_a(particleName, (double)i + 0.875, (double)j + 0.125, (double)k + 0.875, 0.0, 0.0, 0.0);
        world.func_72869_a(particleName, (double)i + 0.1875, (double)j + 0.125, (double)k + 0.5, 0.0, 0.0, 0.0);
        world.func_72869_a(particleName, (double)i + 0.6875, (double)j + 0.125, (double)k + 0.5, 0.0, 0.0, 0.0);
        world.func_72869_a(particleName, (double)i + 0.5, (double)j + 0.125, (double)k + 0.1875, 0.0, 0.0, 0.0);
        world.func_72869_a(particleName, (double)i + 0.5, (double)j + 0.125, (double)k + 0.6875, 0.0, 0.0, 0.0);
    }

    public String getType() {
        return this.type;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        if (!player.field_71075_bZ.field_75099_e && player.field_71071_by.func_146028_b(Main.soul)) {
            for (float i = 0.0f; i < 1.0f; i += 0.1f) {
                String particleName = this.type.equals("blaze") ? "flame" : "smoke";
                world.func_72869_a(particleName, (double)x + 0.5, (double)((float)y + i), (double)z + 0.5, 0.0, 0.0, 0.0);
                world.func_72869_a(particleName, (double)x + 0.45, (double)((float)y + i), (double)z + 0.45, 0.0, 0.0, 0.0);
                world.func_72869_a(particleName, (double)x + 0.45, (double)((float)y + i), (double)z + 0.65, 0.0, 0.0, 0.0);
                world.func_72869_a(particleName, (double)x + 0.65, (double)((float)y + i), (double)z + 0.45, 0.0, 0.0, 0.0);
                world.func_72869_a(particleName, (double)x + 0.65, (double)((float)y + i), (double)z + 0.65, 0.0, 0.0, 0.0);
            }
            try {
                this.setData(player);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!this.type.equals("stone") || this.type.equals("cobblestone") && !this.isGrave || this.type.equals("cobblestone_mossy") && !this.isGrave) {
                world.func_147468_f(x, y, z);
            }
        }
        return true;
    }

    private void setData(EntityPlayer player) throws IOException {
        NBTTagCompound nbt;
        ExtendedPlayerProps cfr_ignored_0 = (ExtendedPlayerProps)player.getExtendedProperties("resurrection_properties");
        ExtendedPlayerProps.setGhostMode(false);
        String fileName = "Ghost.dat";
        File myFile = new File(DimensionManager.getCurrentSaveRootDirectory(), fileName);
        if (!myFile.isFile() && !myFile.exists()) {
            myFile.createNewFile();
        }
        FileInputStream fis = new FileInputStream(myFile);
        DataInputStream instream = new DataInputStream(fis);
        try {
            nbt = CompressedStreamTools.func_74794_a((DataInput)instream);
        }
        catch (Exception e) {
            CompressedStreamTools.func_74795_b((NBTTagCompound)new NBTTagCompound(), (File)myFile);
            nbt = CompressedStreamTools.func_74794_a((DataInput)instream);
        }
        nbt.func_74757_a("isGhost", false);
        CompressedStreamTools.func_74795_b((NBTTagCompound)nbt, (File)myFile);
        instream.close();
        fis.close();
    }

    public void func_149719_a(IBlockAccess p_149719_1_, int p_149719_2_, int p_149719_3_, int p_149719_4_) {
        if (this.isGrave) {
            this.func_149676_a(0.0625f, 0.0f, 0.25f, 0.9375f, 0.8125f, 0.75f);
        } else {
            this.func_149676_a(0.1875f, 0.0f, 0.375f, 0.8125f, 1.0f, 0.625f);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return this.isGrave ? Main.renderGravestone : Main.renderCross;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.field_149761_L = p_149651_1_.func_94245_a(this.field_149827_a);
    }
}

