/*
 * Decompiled with CFR 0.152.
 */
package com.stormister.rediscovered;

import com.stormister.rediscovered.SkyDimensionTeleporter;
import com.stormister.rediscovered.mod_Rediscovered;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDirectional;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Direction;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class BlockDreamBed
extends BlockBed {
    public static final int[][] footBlockToHeadBlockMap = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] field_94472_b;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] bedSideIcons;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] bedTopIcons;

    public BlockDreamBed() {
        this.func_149715_a(0.9f);
        this.setBounds();
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (par1World.field_72995_K) {
            return true;
        }
        int i1 = par1World.func_72805_g(par2, par3, par4);
        if (!BlockDreamBed.isBlockHeadOfBed(i1)) {
            int j1 = BlockDreamBed.func_149895_l((int)i1);
            if (!par1World.func_147439_a(par2 += footBlockToHeadBlockMap[j1][0], par3, par4 += footBlockToHeadBlockMap[j1][1]).equals((Object)this)) {
                return true;
            }
            i1 = par1World.func_72805_g(par2, par3, par4);
        }
        if (par1World.func_72807_a(par2, par4) != BiomeGenBase.field_76778_j && par1World.func_72807_a(par2, par4) != BiomeGenBase.field_76779_k) {
            EntityPlayer.EnumStatus enumstatus;
            if (BlockDreamBed.isBedOccupied(i1)) {
                EntityPlayer entityplayer1 = null;
                for (EntityPlayer entityplayer2 : par1World.field_73010_i) {
                    if (!entityplayer2.func_70608_bn()) continue;
                    ChunkCoordinates chunkcoordinates = entityplayer2.field_71081_bT;
                    if (chunkcoordinates.field_71574_a != par2 || chunkcoordinates.field_71572_b != par3 || chunkcoordinates.field_71573_c != par4) continue;
                    entityplayer1 = entityplayer2;
                }
                if (entityplayer1 != null) {
                    par5EntityPlayer.func_146105_b((IChatComponent)new ChatComponentText("This bed is occupied"));
                    return true;
                }
                BlockDreamBed.setBedOccupied(par1World, par2, par3, par4, false);
            }
            if ((enumstatus = par5EntityPlayer.func_71018_a(par2, par3, par4)) == EntityPlayer.EnumStatus.OK || par1World.func_72807_a(par2, par4) == mod_Rediscovered.heaven || mod_Rediscovered.daytimeBed) {
                BlockDreamBed.setBedOccupied(par1World, par2, par3, par4, true);
                if (par5EntityPlayer instanceof EntityPlayerMP) {
                    EntityPlayerMP thePlayer = (EntityPlayerMP)par5EntityPlayer;
                    if (par5EntityPlayer.field_71093_bK != mod_Rediscovered.DimID) {
                        thePlayer.field_71133_b.func_71203_ab().transferPlayerToDimension(thePlayer, mod_Rediscovered.DimID, (Teleporter)new SkyDimensionTeleporter(thePlayer.field_71133_b.func_71218_a(mod_Rediscovered.DimID)));
                    } else {
                        thePlayer.field_71133_b.func_71203_ab().transferPlayerToDimension(thePlayer, 0, (Teleporter)new SkyDimensionTeleporter(thePlayer.field_71133_b.func_71218_a(0)));
                    }
                }
                return true;
            }
            if (enumstatus == EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW && par1World.func_72807_a(par2, par4) != mod_Rediscovered.heaven) {
                par5EntityPlayer.func_145747_a((IChatComponent)new ChatComponentText("You can only dream at night"));
            } else if (enumstatus == EntityPlayer.EnumStatus.NOT_SAFE) {
                par5EntityPlayer.func_145747_a((IChatComponent)new ChatComponentText("You may not rest now, there are monsters nearby"));
            }
            return true;
        }
        double d0 = (double)par2 + 0.5;
        double d1 = (double)par3 + 0.5;
        double d2 = (double)par4 + 0.5;
        par1World.func_147468_f(par2, par3, par4);
        int k1 = BlockDreamBed.func_149895_l((int)i1);
        if (par1World.func_147439_a(par2 += footBlockToHeadBlockMap[k1][0], par3, par4 += footBlockToHeadBlockMap[k1][1]).equals((Object)this)) {
            par1World.func_147468_f(par2, par3, par4);
            d0 = (d0 + (double)par2 + 0.5) / 2.0;
            d1 = (d1 + (double)par3 + 0.5) / 2.0;
            d2 = (d2 + (double)par4 + 0.5) / 2.0;
        }
        par1World.func_72885_a((Entity)null, (double)((float)par2 + 0.5f), (double)((float)par3 + 0.5f), (double)((float)par4 + 0.5f), 5.0f, true, true);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        int i1;
        if (par1 == 0) {
            return Blocks.field_150344_f.func_149733_h(par1);
        }
        int k = BlockDreamBed.func_149895_l((int)par2);
        int l = Direction.field_71584_h[k][par1];
        int n = i1 = BlockDreamBed.isBlockHeadOfBed(par2) ? 1 : 0;
        return !(i1 == 1 && l == 2 || i1 == 0 && l == 3) ? (l != 5 && l != 4 ? this.bedTopIcons[i1] : this.bedSideIcons[i1]) : this.field_94472_b[i1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.bedTopIcons = new IIcon[]{par1IconRegister.func_94245_a("rediscovered:dreambed_feet_top"), par1IconRegister.func_94245_a("rediscovered:dreambed_head_top")};
        this.field_94472_b = new IIcon[]{par1IconRegister.func_94245_a("rediscovered:dreambed_feet_end"), par1IconRegister.func_94245_a("bed_head_end")};
        this.bedSideIcons = new IIcon[]{par1IconRegister.func_94245_a("rediscovered:dreambed_feet_side"), par1IconRegister.func_94245_a("rediscovered:dreambed_head_side")};
    }

    public int func_149645_b() {
        return 14;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.setBounds();
    }

    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        int i1 = par1World.func_72805_g(par2, par3, par4);
        int j1 = BlockDreamBed.func_149895_l((int)i1);
        if (BlockDreamBed.isBlockHeadOfBed(i1)) {
            if (!par1World.func_147439_a(par2 - footBlockToHeadBlockMap[j1][0], par3, par4 - footBlockToHeadBlockMap[j1][1]).equals((Object)this)) {
                par1World.func_147468_f(par2, par3, par4);
            }
        } else if (!par1World.func_147439_a(par2 + footBlockToHeadBlockMap[j1][0], par3, par4 + footBlockToHeadBlockMap[j1][1]).equals((Object)this)) {
            par1World.func_147468_f(par2, par3, par4);
            if (!par1World.field_72995_K) {
                this.func_149697_b(par1World, par2, par3, par4, i1, 0);
            }
        }
    }

    public Item func_149650_a(int i, Random random, int j) {
        return mod_Rediscovered.DreamBedItem;
    }

    private void setBounds() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5625f, 1.0f);
    }

    public static boolean isBlockHeadOfBed(int par0) {
        return (par0 & 8) != 0;
    }

    public static boolean isBedOccupied(int par0) {
        return (par0 & 4) != 0;
    }

    public static void setBedOccupied(World par0World, int par1, int par2, int par3, boolean par4) {
        int l = par0World.func_72805_g(par1, par2, par3);
        l = par4 ? (l |= 4) : (l &= 0xFFFFFFFB);
        par0World.func_72921_c(par1, par2, par3, l, 4);
    }

    public static ChunkCoordinates getNearestEmptyChunkCoordinates(World par0World, int par1, int par2, int par3, int par4) {
        int i1 = par0World.func_72805_g(par1, par2, par3);
        int j1 = BlockDirectional.func_149895_l((int)i1);
        for (int k1 = 0; k1 <= 1; ++k1) {
            int l1 = par1 - footBlockToHeadBlockMap[j1][0] * k1 - 1;
            int i2 = par3 - footBlockToHeadBlockMap[j1][1] * k1 - 1;
            int j2 = l1 + 2;
            int k2 = i2 + 2;
            for (int l2 = l1; l2 <= j2; ++l2) {
                for (int i3 = i2; i3 <= k2; ++i3) {
                    if (!World.func_147466_a((IBlockAccess)par0World, (int)l2, (int)(par2 - 1), (int)i3) || !par0World.func_147437_c(l2, par2, i3) || !par0World.func_147437_c(l2, par2 + 1, i3)) continue;
                    if (par4 <= 0) {
                        return new ChunkCoordinates(l2, par2, i3);
                    }
                    --par4;
                }
            }
        }
        return null;
    }

    public void func_149690_a(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
        if (!BlockDreamBed.isBlockHeadOfBed(par5)) {
            super.func_149690_a(par1World, par2, par3, par4, par5, par6, 0);
        }
    }

    public int func_149656_h() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack(mod_Rediscovered.DreamBedItem);
    }

    public void func_149681_a(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer) {
        int i1;
        if (par6EntityPlayer.field_71075_bZ.field_75098_d && BlockDreamBed.isBlockHeadOfBed(par5) && par1World.func_147439_a(par2 -= footBlockToHeadBlockMap[i1 = BlockDreamBed.func_149895_l((int)par5)][0], par3, par4 -= footBlockToHeadBlockMap[i1][1]).equals((Object)this)) {
            par1World.func_147468_f(par2, par3, par4);
        }
    }
}

