/*
 * Decompiled with CFR 0.152.
 */
package rancraftPenguins;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import rancraftPenguins.ItemPenguinFishingRod;
import rancraftPenguins.NetworkHelper;
import rancraftPenguins.RanCraftPenguins;

public class RCPacket
implements NetworkHelper.IPacket {
    private EntityPlayer thePlayer;
    private String playerName;
    private String eventType;
    private Minecraft mc;
    private MinecraftServer ms;
    private int iPayload;
    private float fPayload;
    private String sPayload;

    public RCPacket() {
        this.thePlayer = null;
        this.playerName = "";
        this.eventType = "";
        this.mc = null;
        this.ms = null;
        this.iPayload = 0;
        this.fPayload = 0.0f;
    }

    public RCPacket(String event, EntityPlayer player, int intP) {
        this.thePlayer = player;
        this.playerName = player.getDisplayName();
        this.eventType = event;
        this.iPayload = intP;
    }

    @SideOnly(value=Side.CLIENT)
    public RCPacket(String event, String player) {
        this.playerName = player;
        this.eventType = event;
        this.iPayload = 0;
        this.fPayload = 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public RCPacket(String event, String player, int intP) {
        this.playerName = player;
        this.eventType = event;
        this.iPayload = intP;
        this.fPayload = 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public RCPacket(String event, String player, float floatP) {
        this.playerName = player;
        this.eventType = event;
        this.iPayload = 0;
        this.fPayload = floatP;
    }

    @Override
    public void writeBytes(ChannelHandlerContext ctx, ByteBuf bytes) {
        String s = new String(this.playerName);
        String e = new String(this.eventType);
        bytes.writeShort(s.length());
        for (char c : s.toCharArray()) {
            bytes.writeChar((int)c);
        }
        bytes.writeShort(e.length());
        for (char c : e.toCharArray()) {
            bytes.writeChar((int)c);
        }
        if (this.eventType.compareTo("RC_AL") == 0) {
            bytes.writeInt(this.iPayload);
        }
        if (this.eventType.compareTo("RC_FD") == 0) {
            bytes.writeFloat(this.fPayload);
        }
        if (this.eventType.compareTo("RC_PFRI") == 0) {
            bytes.writeInt(this.iPayload);
        }
    }

    @Override
    public void readBytes(ChannelHandlerContext ctx, ByteBuf bytes) {
        ItemStack currItemStack;
        int len = bytes.readShort();
        char[] pChars1 = new char[len];
        for (int i = 0; i < len; ++i) {
            pChars1[i] = bytes.readChar();
        }
        this.playerName = String.valueOf(pChars1);
        EntityPlayerMP playerMP = null;
        if (MinecraftServer.func_71276_C() != null) {
            playerMP = MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(this.playerName);
        }
        len = bytes.readShort();
        char[] pChars2 = new char[len];
        for (int i = 0; i < len; ++i) {
            pChars2[i] = bytes.readChar();
        }
        this.eventType = String.valueOf(pChars2);
        if (MinecraftServer.func_71276_C() != null) {
            // empty if block
        }
        int extinguish = 451;
        int maxAir = 300;
        int incomingI = 0;
        float incomingF = 0.0f;
        if (this.eventType.compareTo("RC_FRSR") == 0 && playerMP.func_71045_bC() != null) {
            try {
                this.sendFishingRodState((EntityPlayer)playerMP, playerMP.func_71045_bC().func_77973_b());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("RCPacket: Error reading packet");
                return;
            }
        }
        if (this.eventType.compareTo("RC_Ext") == 0) {
            try {
                playerMP.func_70066_B();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("RCPacket: Error reading packet");
                return;
            }
        }
        if (this.eventType.compareTo("RC_AL") == 0) {
            try {
                incomingI = bytes.readInt();
                if (incomingI > -1 && incomingI < maxAir + 1) {
                    playerMP.func_70050_g(incomingI);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("RCPacket: Error reading packet");
                return;
            }
        }
        if (this.eventType.compareTo("RC_FD") == 0) {
            try {
                playerMP.field_70143_R = incomingF = bytes.readFloat();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("RCPacket: Error reading packet");
                return;
            }
        }
        if (this.eventType.compareTo("RC_PFRI") == 0 && FMLCommonHandler.instance().getEffectiveSide().isClient() && (currItemStack = Minecraft.func_71410_x().field_71439_g.func_71045_bC()) != null && currItemStack.func_77973_b() == RanCraftPenguins.PenguinFishingRod) {
            incomingI = 0;
            try {
                incomingI = bytes.readInt();
                ((ItemPenguinFishingRod)currItemStack.func_77973_b()).setIconTo(incomingI);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("RCPacket RC_PFRI: Error reading packet or setting the item icon");
                return;
            }
        }
    }

    public void sendFishingRodState(EntityPlayer player, Item currentItem) {
        if (currentItem != null && currentItem.equals(RanCraftPenguins.PenguinFishingRod)) {
            ItemPenguinFishingRod pfr = (ItemPenguinFishingRod)currentItem;
            try {
                RCPacket packet = new RCPacket("RC_PFRI", player, ItemPenguinFishingRod.rodIcon);
                RanCraftPenguins.nh.sendPacketToPlayer(packet, player);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("Client: Error creating packet");
            }
        }
    }
}

