/*
 * Decompiled with CFR 0.152.
 */
package net.row.stock.core;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityExplodeFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.row.RoW;
import net.row.helpers.RotativePoint;
import net.row.network.PacketLight;
import net.row.registry.RoWConfig;
import net.row.stock.core.RoWRollingStock;

public class RoWLocomotiveSteam
extends RoWRollingStock {
    public boolean horn = false;
    public boolean zeroReverse = false;
    public boolean brake;
    public boolean pistonfx = false;
    public boolean isHeadLightOn = false;
    public boolean hasLight = false;
    public byte hornStage = 0;
    public byte brakeStage = 0;
    public byte reverse = 0;
    public byte regulator = 0;
    public float maxForce = 10.0f;
    public float maxClutchSpeed;
    public RotativePoint smokePos = new RotativePoint(this, 0.0f, 0.0f, 0.0f);
    public RotativePoint steamPosLeft = new RotativePoint(this, 0.0f, 0.0f, 0.0f);
    public RotativePoint steamPosRight = new RotativePoint(this, 0.0f, 0.0f, 0.0f);
    public RotativePoint lightsPos = new RotativePoint(this, 0.0f, 0.0f, 0.0f);
    public int lastLightPosX = 0;
    public int lastLightPosY = -1;
    public int lastLightPosZ = 0;
    public int fuel = 0;
    public int maxFuel = 4000;
    public int colour = colours[0];
    public String hornSound = "";
    public String pistonSound = "";
    public static final int[] colours = new int[]{0x505050, 0xFF0000, 3887386, 5320730, 2437522, 8073150, 2651799, 0xABABAB, 0x434343, 14188952, 4312372, 14602026, 6719955, 12801229, 15435844, 0xF0F0F0};

    public RoWLocomotiveSteam(World par1World) {
        super(par1World);
        this.field_70180_af.func_75682_a(8, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(10, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(12, (Object)new String());
        this.func_70088_a();
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(8, (Object)this.fuel);
        } else {
            this.fuel = this.field_70180_af.func_75679_c(8);
        }
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.field_70153_n != player) {
            return true;
        }
        if (this.field_70153_n != null && this.field_70153_n != player) {
            this.field_70153_n.func_70078_a(null);
            return false;
        }
        ItemStack item = player.field_71071_by.func_70448_g();
        if (!this.field_70170_p.field_72995_K && item != null) {
            if (item.func_77973_b() == Items.field_151040_l && player.field_71075_bZ.field_75098_d) {
                this.isHeadLightOn = false;
                this.burnLight(this.lightsPos);
                this.field_70170_p.func_72900_e((Entity)this);
                return true;
            }
            if (item.func_77973_b() == Items.field_151044_h && this.fuel < this.maxFuel) {
                this.fuel += 1000;
                if (!player.field_71075_bZ.field_75098_d && --item.field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
                return true;
            }
            if (item.func_77973_b() == Items.field_151100_aR) {
                this.colour = colours[item.func_77960_j()];
                if (!player.field_71075_bZ.field_75098_d && --item.field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
                return true;
            }
            if (item.func_77973_b() == Items.field_151057_cb) {
                this.label = item.func_82833_r().length() > 8 ? item.func_82833_r().substring(0, 8) : item.func_82833_r();
                return true;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_70078_a((Entity)this);
            return true;
        }
        return false;
    }

    @Override
    public void func_70071_h_() {
        this.onLocoUpdate();
        this.func_70030_z();
    }

    public void onLocoUpdate() {
        this.lightsPos.onUpdate();
        this.smokePos.onUpdate();
        this.steamPosLeft.onUpdate();
        this.steamPosRight.onUpdate();
        if (RoWConfig.enableDynamicLighting && this.hasLight) {
            this.burnLight(this.lightsPos);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.wheelAngle[0] > -20.0f && this.wheelAngle[0] < 20.0f || this.wheelAngle[0] > 160.0f || this.wheelAngle[0] < -160.0f) {
                if (!this.pistonfx && this.fuel > 0 && this.reverse != 0) {
                    this.field_70170_p.func_72956_a((Entity)this, "row:" + this.pistonSound, 1.5f, 1.0f + 0.5f * (float)Math.abs(this.reverse) / 128.0f);
                    this.pistonfx = true;
                }
            } else {
                this.pistonfx = false;
            }
        } else if (this.wheelAngle[0] > -30.0f && this.wheelAngle[0] < 30.0f || this.wheelAngle[0] > 150.0f || this.wheelAngle[0] < -150.0f) {
            if (!this.pistonfx && this.fuel > 0) {
                this.pistonfx = true;
                for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                    EntityExplodeFX steamfx = new EntityExplodeFX(this.field_70170_p, (double)this.steamPosLeft.getX(), (double)this.steamPosLeft.getY(), (double)this.steamPosLeft.getZ(), 0.0, 0.0, 0.0);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)steamfx);
                    steamfx = new EntityExplodeFX(this.field_70170_p, (double)this.steamPosRight.getX(), (double)this.steamPosRight.getY(), (double)this.steamPosRight.getZ(), 0.0, 0.0, 0.0);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)steamfx);
                }
            }
        } else {
            this.pistonfx = false;
        }
        if (this.zeroReverse) {
            if (this.reverse > 5) {
                this.reverse = (byte)(this.reverse - 5);
            } else if (this.reverse < -5) {
                this.reverse = (byte)(this.reverse + 5);
            } else {
                this.zeroReverse = false;
                this.reverse = 0;
            }
        }
        if (this.brake) {
            this.field_70159_w *= 0.8;
            this.field_70181_x *= 0.8;
            this.field_70179_y *= 0.8;
            if (this.brakeStage == 0) {
                this.field_70170_p.func_72956_a((Entity)this, "row:brake", 1.0f, 1.5f);
            }
        }
        if (this.brake && this.brakeStage < 30) {
            this.brakeStage = (byte)(this.brakeStage + 1);
        }
        if (!this.brake && this.brakeStage > 0) {
            this.brakeStage = (byte)(this.brakeStage - 1);
        }
        if (this.hornStage == 50 && this.fuel > 0) {
            this.field_70170_p.func_72956_a((Entity)this, "row:" + this.hornSound, 2.0f, 1.0f);
        }
        this.hornStage = this.hornStage > 1 ? (byte)(this.hornStage - 1) : (byte)0;
        float trainmass = this.mass;
        if (this.fuel > 0) {
            if (!this.field_70170_p.field_72995_K) {
                if (!this.brake && this.reverse != 0) {
                    float c = (float)this.reverse * this.maxForce / 64.0f / trainmass / 256.0f;
                    RoWLocomotiveSteam cart = this;
                    cart.applyForwardMotion(c);
                }
            } else {
                this.spawnFx();
            }
            --this.fuel;
        } else {
            this.fuel = 0;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(8, (Object)this.fuel);
            this.field_70180_af.func_75692_b(10, (Object)this.colour);
            this.field_70180_af.func_75692_b(12, (Object)String.valueOf(this.label));
        } else {
            this.fuel = this.field_70180_af.func_75679_c(8);
            this.colour = this.field_70180_af.func_75679_c(10);
            this.label = this.field_70180_af.func_75681_e(12);
        }
        if (this.brake) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
    }

    public void burnLight(RotativePoint light) {
        int i = MathHelper.func_76128_c((double)light.getX());
        int j = MathHelper.func_76128_c((double)light.getY());
        int k = MathHelper.func_76128_c((double)light.getZ());
        if (!this.field_70170_p.field_72995_K) {
            if (this.isHeadLightOn) {
                if (i != this.lastLightPosX || j != this.lastLightPosY || k != this.lastLightPosZ) {
                    RoW.packetPipeline.sendToServer(new PacketLight(i, j, k, this.lastLightPosX, this.lastLightPosY, this.lastLightPosZ, 15));
                    this.lastLightPosX = i;
                    this.lastLightPosY = j;
                    this.lastLightPosZ = k;
                }
            } else {
                RoW.packetPipeline.sendToServer(new PacketLight(i, j, k, 0, -1, 0, 0));
                this.lastLightPosY = -1;
            }
        }
    }

    public void spawnFx() {
    }

    @Override
    public boolean canRiderInteract() {
        return true;
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.fuel = nbttagcompound.func_74762_e("fuel");
        this.isHeadLightOn = nbttagcompound.func_74767_n("isHeadLightOn");
        this.reverse = nbttagcompound.func_74771_c("reverse");
        this.colour = nbttagcompound.func_74762_e("colour");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("fuel", this.fuel);
        nbttagcompound.func_74757_a("isHeadLightOn", this.isHeadLightOn);
        nbttagcompound.func_74774_a("reverse", this.reverse);
        nbttagcompound.func_74768_a("colour", this.colour);
    }
}

