/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.DataTools;
import mods.railcraft.common.util.network.IEditableItem;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;

public class PacketCurrentItemNBT
extends RailcraftPacket {
    private final EntityPlayer player;
    private final ItemStack currentItem;

    public PacketCurrentItemNBT(EntityPlayer player, ItemStack stack) {
        this.player = player;
        this.currentItem = stack;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        DataTools.writeItemStack(this.currentItem, data);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        try {
            ItemStack stack = DataTools.readItemStack(data);
            if (stack == null || this.currentItem == null) {
                return;
            }
            if (stack.func_77973_b() != this.currentItem.func_77973_b()) {
                return;
            }
            if (!(this.currentItem.func_77973_b() instanceof IEditableItem)) {
                return;
            }
            IEditableItem eItem = (IEditableItem)stack.func_77973_b();
            if (!eItem.canPlayerEdit(this.player, this.currentItem)) {
                Game.log(Level.WARN, "{0} attempted to edit an item he is not allowed to edit {0}.", Railcraft.proxy.getPlayerUsername(this.player), this.currentItem.func_77973_b().func_77658_a());
                return;
            }
            if (!eItem.validateNBT(stack.func_77978_p())) {
                Game.log(Level.WARN, "Item NBT not valid!", new Object[0]);
                return;
            }
            this.currentItem.func_77982_d(stack.func_77978_p());
        }
        catch (Exception exception) {
            Game.logThrowable("Error reading Item NBT packet", exception, new Object[0]);
        }
    }

    public void sendPacket() {
        PacketDispatcher.sendToServer(this);
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.ITEM_NBT.ordinal();
    }
}

