/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.misc;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFormatMessage;

public class Game {
    public static final boolean IS_OBFUSCATED = !World.class.getSimpleName().equals("World");
    public static final boolean IS_DEBUG = !"@VERSION@".endsWith("0");

    public static boolean isHost(World world) {
        return !world.field_72995_K;
    }

    public static boolean isNotHost(World world) {
        return world.field_72995_K;
    }

    public static boolean isPlayerOp(EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            throw new RuntimeException("You derped up! Don't call this on the client!");
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72353_e(player.func_70005_c_());
    }

    public static boolean isPlayerOp(String username) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            throw new RuntimeException("You derped up! Don't call this on the client!");
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72353_e(username);
    }

    public static boolean isPlayerConnected(String username) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72361_f(username) != null;
    }

    @SideOnly(value=Side.CLIENT)
    public static World getWorld() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null) {
            return mc.field_71441_e;
        }
        return null;
    }

    public static boolean isObfuscated() {
        return IS_OBFUSCATED;
    }

    public static void log(Level level, String msg, Object ... args) {
        LogManager.getLogger((String)"Railcraft").log(level, (Message)new MessageFormatMessage(msg, args));
    }

    public static void logTrace(Level level, String msg, Object ... args) {
        Game.logTrace(level, 5, msg, args);
    }

    public static void logTrace(Level level, int lines, String msg, Object ... args) {
        Game.log(level, msg, args);
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < stackTrace.length && i < 2 + lines; ++i) {
            Game.log(level, stackTrace[i].toString(), new Object[0]);
        }
    }

    public static void logThrowable(String msg, Throwable error, Object ... args) {
        Game.logThrowable(Level.ERROR, msg, 3, error, args);
    }

    public static void logThrowable(String msg, int lines, Throwable error, Object ... args) {
        Game.logThrowable(Level.ERROR, msg, lines, error, args);
    }

    public static void logThrowable(Level level, String msg, int lines, Throwable error, Object ... args) {
        StackTraceElement[] oldtrace = error.getStackTrace();
        if (lines < oldtrace.length) {
            StackTraceElement[] newtrace = new StackTraceElement[lines];
            System.arraycopy(oldtrace, 0, newtrace, 0, newtrace.length);
            error.setStackTrace(newtrace);
        }
        LogManager.getLogger((String)"Railcraft").log(level, (Message)new MessageFormatMessage(msg, args), error);
    }

    public static void logDebug(String msg, Object ... args) {
        if (!IS_DEBUG) {
            return;
        }
        Game.log(Level.DEBUG, msg, args);
    }

    public static void logErrorAPI(String mod, Throwable error, Class classFile) {
        StringBuilder msg = new StringBuilder(mod);
        msg.append(" API error, please update your mods. Error: ").append(error);
        Game.logThrowable(Level.ERROR, msg.toString(), 2, error, new Object[0]);
        if (classFile != null) {
            msg = new StringBuilder(mod);
            msg.append(" API error: ").append(classFile.getSimpleName()).append(" is loaded from ").append(classFile.getProtectionDomain().getCodeSource().getLocation());
            Game.log(Level.ERROR, msg.toString(), new Object[0]);
        }
    }

    public static void logErrorFingerprint(String mod) {
        StringBuilder msg = new StringBuilder(mod);
        msg.append(" failed validation, terminating. Please re-download ").append(mod).append(".");
        Game.log(Level.FATAL, msg.toString(), new Object[0]);
    }
}

