/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forge;

import cpw.mods.fml.common.IFuelHandler;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.FluidStack;

public class FuelPlugin {
    private static IFuelHandler fuelHandler;
    private static ItemStack lastFuel;
    private static int lastFuelValue;

    public static IFuelHandler getFuelHandler() {
        if (fuelHandler == null) {
            fuelHandler = new FuelHandler();
        }
        return fuelHandler;
    }

    public static int getBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        if (InvTools.isItemEqualSemiStrict(stack, lastFuel)) {
            return lastFuelValue;
        }
        lastFuel = stack;
        lastFuelValue = FuelPlugin.findFuelValue(stack);
        return lastFuelValue;
    }

    private static int findFuelValue(ItemStack stack) {
        try {
            Block block;
            String name;
            Item item = stack.func_77973_b();
            if (item instanceof ItemBlock && (name = (block = InvTools.getBlockFromStack(stack)).func_149739_a()) != null && name.contains("blockScaffold")) {
                return 0;
            }
            if (item == Items.field_151072_bj) {
                return 1000;
            }
            FluidStack liquid = FluidHelper.getFluidStackInContainer(stack);
            if (liquid != null && Fluids.LAVA.get() == liquid.getFluid()) {
                return liquid.amount;
            }
            name = stack.func_77973_b().func_77658_a();
            if (name != null && name.contains("itemScrap")) {
                return 0;
            }
            return TileEntityFurnace.func_145952_a((ItemStack)stack);
        }
        catch (Exception ex) {
            Game.logThrowable("Error in Fuel Handler! Is some mod creating items that are not compliant with standards?", ex, new Object[0]);
            return 0;
        }
    }

    private static class FuelHandler
    implements IFuelHandler {
        private static final int COKE_HEAT = 3200;
        private final ItemStack coke = RailcraftToolItems.getCoalCoke();
        private final ItemStack cokeBlock = EnumCube.COKE_BLOCK.getItem();

        private FuelHandler() {
        }

        public int getBurnTime(ItemStack fuel) {
            if (fuel == null) {
                return 0;
            }
            if (InvTools.isItemEqual(fuel, this.coke)) {
                return 3200;
            }
            if (InvTools.isItemEqual(fuel, this.cokeBlock)) {
                return 28800;
            }
            if (fuel.func_77973_b() instanceof ItemRailcraft) {
                return ((ItemRailcraft)fuel.func_77973_b()).getHeatValue(fuel);
            }
            return 0;
        }
    }
}

