/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forestry;

import mods.railcraft.common.blocks.aesthetics.EnumBlockMaterial;
import mods.railcraft.common.blocks.aesthetics.slab.BlockRailcraftSlab;
import mods.railcraft.common.blocks.aesthetics.stairs.BlockRailcraftStairs;
import mods.railcraft.common.blocks.aesthetics.wall.EnumWallAlpha;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forestry.BaseBackpack;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class IcemanBackpack
extends BaseBackpack {
    private static IcemanBackpack instance;
    private static final ItemStack SNOWBALL;
    private static final ItemStack SNOWBLOCK;
    private static final String INV_TAG = "Items";

    public static IcemanBackpack getInstance() {
        if (instance == null) {
            instance = new IcemanBackpack();
        }
        return instance;
    }

    protected IcemanBackpack() {
    }

    public void setup() {
        this.addValidItem(Blocks.field_150433_aE);
        this.addValidItem(Blocks.field_150431_aC);
        this.addValidItem(Blocks.field_150432_aD);
        this.addValidItem(EnumWallAlpha.SNOW.getItem());
        this.addValidItem(EnumWallAlpha.ICE.getItem());
        this.addValidItem(BlockRailcraftStairs.getItem(EnumBlockMaterial.SNOW));
        this.addValidItem(BlockRailcraftStairs.getItem(EnumBlockMaterial.ICE));
        this.addValidItem(BlockRailcraftSlab.getItem(EnumBlockMaterial.SNOW));
        this.addValidItem(BlockRailcraftSlab.getItem(EnumBlockMaterial.ICE));
        this.addValidItem(Items.field_151126_ay);
    }

    public void compactInventory(ItemStack backpack) {
        StandaloneInventory inv = new StandaloneInventory(45);
        NBTTagCompound data = backpack.func_77978_p();
        if (data == null) {
            return;
        }
        InvTools.readInvFromNBT(inv, INV_TAG, data);
        int numSnowballs = InvTools.countItems((IInventory)inv, SNOWBALL);
        if (numSnowballs >= 16) {
            for (int i = 0; i < 4; ++i) {
                InvTools.removeOneItem((IInventory)inv, SNOWBALL);
            }
            if (InvTools.moveItemStack(new ItemStack(Blocks.field_150433_aE), inv) == null) {
                InvTools.writeInvToNBT(inv, INV_TAG, data);
            }
        } else if (numSnowballs < 8 && InvTools.removeOneItem((IInventory)inv, SNOWBLOCK) != null && InvTools.moveItemStack(new ItemStack(Items.field_151126_ay, 4), inv) == null) {
            InvTools.writeInvToNBT(inv, INV_TAG, data);
        }
    }

    @Override
    public String getKey() {
        return "ICEMAN";
    }

    @Override
    public String getName() {
        return RailcraftLanguage.translate("backpack.iceman.t1");
    }

    @Override
    public int getPrimaryColour() {
        return 0xFFFFFF;
    }

    @Override
    public int getSecondaryColour() {
        return 0xFFFFFF;
    }

    static {
        SNOWBALL = new ItemStack(Items.field_151126_ay);
        SNOWBLOCK = new ItemStack(Blocks.field_150433_aE);
    }
}

