/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.buildcraft.actions;

import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import mods.railcraft.common.core.RailcraftLanguage;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public enum Actions implements IAction
{
    PAUSE(400, "pause"),
    SEND_CART(401, "sendcart");

    public static final Actions[] VALUES;
    private final int id;
    private final String tag;
    private IIcon icon;

    private Actions(int id, String tag) {
        this.id = id;
        this.tag = tag;
    }

    public static void init() {
        for (Actions action : VALUES) {
            ActionManager.registerAction(action);
        }
    }

    @Override
    public String getUniqueTag() {
        return "railcraft." + this.tag;
    }

    @Override
    public final IIcon getIcon() {
        return this.icon;
    }

    @Override
    public boolean hasParameter() {
        return false;
    }

    @Override
    public String getDescription() {
        return RailcraftLanguage.translate("gates.action." + this.tag);
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("railcraft:buildcraft.gate.action." + this.tag);
    }

    static {
        VALUES = Actions.values();
    }
}

