/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.api.fuel.FuelManager;
import mods.railcraft.api.helpers.Helpers;
import mods.railcraft.api.signals.SignalTools;
import mods.railcraft.client.sounds.SoundLimiterTicker;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MachineTileRegistery;
import mods.railcraft.common.blocks.machine.MultiBlockHelper;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.delta.EnumMachineDelta;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.LinkageHandler;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.MinecartHooks;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.fluids.BucketHandler;
import mods.railcraft.common.fluids.FluidContainers;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.RailcraftFluids;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.items.CrowbarHandler;
import mods.railcraft.common.items.EntityItemFireproof;
import mods.railcraft.common.items.ItemCrowbar;
import mods.railcraft.common.items.ItemCrowbarReinforced;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.items.ItemMagnifyingGlass;
import mods.railcraft.common.items.ItemNugget;
import mods.railcraft.common.items.RailcraftPartItems;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.modules.AbstractModule;
import mods.railcraft.common.plugins.buildcraft.BuildcraftPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.util.crafting.BlastFurnaceCraftingManager;
import mods.railcraft.common.util.crafting.CokeOvenCraftingManager;
import mods.railcraft.common.util.crafting.CraftingHandler;
import mods.railcraft.common.util.crafting.RockCrusherCraftingManager;
import mods.railcraft.common.util.crafting.RollingMachineCraftingManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.IMinecartCollisionHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.Level;

public class ModuleCore
extends AbstractModule {
    @Override
    public void preInit() {
        LinkageManager.reset();
        RailcraftCraftingManager.cokeOven = new CokeOvenCraftingManager();
        RailcraftCraftingManager.blastFurnace = new BlastFurnaceCraftingManager();
        RailcraftCraftingManager.rockCrusher = new RockCrusherCraftingManager();
        RailcraftCraftingManager.rollingMachine = new RollingMachineCraftingManager();
        SignalTools.packetBuilder = PacketBuilder.instance();
        RailcraftFluids.preInit();
        MinecraftForge.EVENT_BUS.register((Object)RailcraftFluids.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)BucketHandler.INSTANCE);
        Helpers.structures = new MultiBlockHelper();
        EntityItemFireproof.register();
    }

    @Override
    public void initFirst() {
        ShapedOreRecipe recipe;
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Railcraft.getMod(), (IGuiHandler)new GuiHandler());
        LootPlugin.increaseLootGen(1, 2, "mineshaftCorridor", "villageBlacksmith");
        ItemCrowbar.registerItem();
        ItemCrowbarReinforced.registerItem();
        MinecraftForge.EVENT_BUS.register((Object)CrowbarHandler.instance());
        ItemMagnifyingGlass.register();
        ItemGoggles.registerItem();
        RailcraftToolItems.initializeToolsArmor();
        ItemNugget.getNugget(ItemNugget.EnumNugget.IRON);
        EntityEnderman.setCarriable((Block)Blocks.field_150351_n, (boolean)false);
        BuildcraftPlugin.init();
        MinecraftForge.EVENT_BUS.register((Object)MinecartHooks.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)LinkageHandler.getInstance());
        FMLCommonHandler.instance().bus().register((Object)new CraftingHandler());
        FMLCommonHandler.instance().bus().register((Object)new SoundLimiterTicker());
        if (RailcraftConfig.useCollisionHandler()) {
            if (EntityMinecart.getCollisionHandler() != null) {
                Game.log(Level.WARN, "Existing Minecart Collision Handler detected, overwriting. Please check your configs to ensure this is desired behavior.", new Object[0]);
            }
            EntityMinecart.setCollisionHandler((IMinecartCollisionHandler)MinecartHooks.getInstance());
        }
        HashSet<Item> testSet = new HashSet<Item>();
        if (!RailcraftConfig.useOldRecipes()) {
            testSet.add(Item.func_150898_a((Block)Blocks.field_150448_aq));
            testSet.add(Item.func_150898_a((Block)Blocks.field_150318_D));
            testSet.add(Item.func_150898_a((Block)Blocks.field_150319_E));
            testSet.add(Item.func_150898_a((Block)Blocks.field_150408_cc));
        }
        if (RailcraftConfig.getRecipeConfig("railcraft.cart.furnace")) {
            testSet.add(Items.field_151109_aJ);
        }
        Iterator it = CraftingManager.func_77594_a().func_77592_b().iterator();
        while (it.hasNext()) {
            IRecipe r = (IRecipe)it.next();
            ItemStack output = r.func_77571_b();
            if (output == null || !testSet.contains(output.func_77973_b())) continue;
            it.remove();
        }
        this.replaceVanillaCart(EnumCart.BASIC, Items.field_151143_au, "MinecartRideable", 42);
        this.replaceVanillaCart(EnumCart.CHEST, Items.field_151108_aI, "MinecartChest", 43);
        this.replaceVanillaCart(EnumCart.FURNACE, Items.field_151109_aJ, "MinecartFurnace", 44);
        this.replaceVanillaCart(EnumCart.TNT, Items.field_151142_bV, "MinecartTNT", 45);
        CraftingPlugin.addShapelessRecipe(new ItemStack(Items.field_151143_au), Items.field_151108_aI);
        CraftingPlugin.addShapelessRecipe(new ItemStack(Items.field_151143_au), Items.field_151109_aJ);
        CraftingPlugin.addShapelessRecipe(new ItemStack(Items.field_151143_au), Items.field_151142_bV);
        LootPlugin.addLootMineshaft(EnumCart.BASIC.getCartItem(), 1, 1, "cart.basic");
        LootPlugin.addLootMineshaft(EnumCart.CHEST.getCartItem(), 1, 1, "cart.chest");
        LootPlugin.addLootMineshaft(EnumCart.TNT.getCartItem(), 1, 3, "cart.tnt");
        LootPlugin.addLootMineshaft(new ItemStack(Blocks.field_150448_aq), 8, 32, "track.basic");
        Blocks.field_150448_aq.setHarvestLevel("pickaxe", 0);
        Blocks.field_150448_aq.setHarvestLevel("crowbar", 0);
        Blocks.field_150318_D.setHarvestLevel("pickaxe", 0);
        Blocks.field_150318_D.setHarvestLevel("crowbar", 0);
        Blocks.field_150319_E.setHarvestLevel("pickaxe", 0);
        Blocks.field_150319_E.setHarvestLevel("crowbar", 0);
        Blocks.field_150408_cc.setHarvestLevel("pickaxe", 0);
        Blocks.field_150408_cc.setHarvestLevel("crowbar", 0);
        if (RailcraftConfig.getRecipeConfig("railcraft.cart.bronze")) {
            recipe = new ShapedOreRecipe(new ItemStack(Items.field_151143_au), new Object[]{false, new Object[]{"I I", "III", Character.valueOf('I'), "ingotBronze"}});
            CraftingManager.func_77594_a().func_77592_b().add(recipe);
        }
        if (RailcraftConfig.getRecipeConfig("railcraft.cart.steel")) {
            recipe = new ShapedOreRecipe(new ItemStack(Items.field_151143_au, 2), new Object[]{false, new Object[]{"I I", "III", Character.valueOf('I'), "ingotSteel"}});
            CraftingManager.func_77594_a().func_77592_b().add(recipe);
        }
        if (!RailcraftConfig.useOldRecipes()) {
            ItemStack stackRailNormal = new ItemStack(Blocks.field_150448_aq, 32);
            ItemStack stackRailBooster = new ItemStack(Blocks.field_150318_D, 16);
            ItemStack stackRailDetector = new ItemStack(Blocks.field_150319_E, 16);
            ItemStack stackRailActivator = new ItemStack(Blocks.field_150408_cc, 16);
            CraftingPlugin.addShapedRecipe(stackRailNormal, "I I", "I#I", "I I", Character.valueOf('I'), RailcraftPartItems.getRailStandard(), Character.valueOf('#'), RailcraftPartItems.getRailbedWood());
            CraftingPlugin.addShapedRecipe(stackRailBooster, "I I", "I#I", "IrI", Character.valueOf('I'), RailcraftPartItems.getRailAdvanced(), Character.valueOf('#'), RailcraftPartItems.getRailbedWood(), Character.valueOf('r'), Items.field_151137_ax);
            CraftingPlugin.addShapedRecipe(stackRailDetector, "IsI", "I#I", "IrI", Character.valueOf('I'), RailcraftPartItems.getRailStandard(), Character.valueOf('#'), Blocks.field_150456_au, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('s'), RailcraftPartItems.getRailbedWood());
            CraftingPlugin.addShapedRecipe(stackRailActivator, "ItI", "I#I", "ItI", Character.valueOf('I'), RailcraftPartItems.getRailStandard(), Character.valueOf('#'), RailcraftPartItems.getRailbedWood(), Character.valueOf('t'), new ItemStack(Blocks.field_150429_aA));
            CraftingPlugin.addShapelessRecipe(RailcraftPartItems.getRailStandard(), Blocks.field_150448_aq, Blocks.field_150448_aq, Blocks.field_150448_aq, Blocks.field_150448_aq, Blocks.field_150448_aq, Blocks.field_150448_aq, Blocks.field_150448_aq, Blocks.field_150448_aq);
            RailcraftLanguage.instance().registerItemName(stackRailNormal, "track.standard");
            RailcraftLanguage.instance().registerItemName(stackRailBooster, "track.powered");
            RailcraftLanguage.instance().registerItemName(stackRailDetector, "track.detector");
            RailcraftLanguage.instance().registerItemName(stackRailActivator, "track.activator");
        }
        MachineTileRegistery.registerTileEntities();
    }

    private void replaceVanillaCart(EnumCart cartType, Item original, String entityTag, int entityId) {
        cartType.registerEntity();
        MinecartHooks.vanillaEntityReplacements.put(original, cartType);
        EntityList.field_75625_b.remove(entityTag);
        EntityList.field_75623_d.remove(entityId);
        EntityList.func_75618_a(cartType.getCartClass(), (String)entityTag, (int)entityId);
        BlockDispenser.field_149943_a.func_82595_a((Object)original, null);
        original.func_77625_d(RailcraftConfig.getMinecartStackSize());
        cartType.setCartItem(new ItemStack(original));
    }

    @Override
    public void initSecond() {
        if (RailcraftConfig.useCreosoteFurnaceRecipes() || !EnumMachineAlpha.COKE_OVEN.isAvaliable()) {
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(Items.field_151044_h, 1, 0), FluidContainers.getCreosoteOilBottle(2), 0.0f);
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(Items.field_151044_h, 1, 1), FluidContainers.getCreosoteOilBottle(1), 0.0f);
        }
    }

    @Override
    public void postInit() {
        RailcraftFluids.postInit();
        GameRegistry.registerFuelHandler((IFuelHandler)FuelPlugin.getFuelHandler());
        ModuleCore.addLiquidFuels();
        FluidHelper.nerfWaterBottle();
        HashSet<Enum> machines = new HashSet<Enum>();
        machines.addAll(EnumSet.allOf(EnumMachineAlpha.class));
        machines.addAll(EnumSet.allOf(EnumMachineBeta.class));
        machines.addAll(EnumSet.allOf(EnumMachineGamma.class));
        machines.addAll(EnumSet.allOf(EnumMachineDelta.class));
        for (IEnumMachine iEnumMachine : machines) {
            if (!iEnumMachine.isAvaliable()) continue;
            ItemRegistry.registerItemStack(iEnumMachine.getTag(), iEnumMachine.getItem());
        }
    }

    public static void addLiquidFuels() {
        Fluid creosote;
        Fluid fuel;
        Fluid biofuel;
        int bioheat = (int)(16000.0f * RailcraftConfig.boilerBiofuelMultiplier());
        Fluid ethanol = Fluids.BIOETHANOL.get();
        if (ethanol != null) {
            FuelManager.addBoilerFuel(ethanol, bioheat);
        }
        if ((biofuel = Fluids.BIOFUEL.get()) != null) {
            FuelManager.addBoilerFuel(biofuel, bioheat);
        }
        if ((fuel = Fluids.FUEL.get()) != null) {
            FuelManager.addBoilerFuel(fuel, (int)(48000.0f * RailcraftConfig.boilerFuelMultiplier()));
        }
        if ((creosote = Fluids.CREOSOTE.get()) != null) {
            FuelManager.addBoilerFuel(creosote, 4800);
        }
    }
}

