/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items.firestone;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.items.firestone.ItemFirestoneRefined;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class TileFirestoneRecharge
extends RailcraftTileEntity {
    public static final int[] REBUILD_DELAY = new int[8];
    public int charge = 0;
    public long rotationYaw;
    public long preRotationYaw;
    public float yOffset = -2.0f;
    public float preYOffset = -2.0f;
    private final Deque<WorldCoordinate> queue = new LinkedList<WorldCoordinate>();
    private final Set<WorldCoordinate> visitedBlocks = new HashSet<WorldCoordinate>();
    private Deque<WorldCoordinate> lavaFound = new LinkedList<WorldCoordinate>();
    private int rebuildDelay;

    @Override
    public void func_145845_h() {
        WorldCoordinate index;
        super.func_145845_h();
        if (Game.isNotHost(this.field_145850_b)) {
            this.preRotationYaw = this.rotationYaw;
            this.rotationYaw += 5L;
            if (this.rotationYaw >= 360L) {
                this.preRotationYaw = this.rotationYaw = 0L;
            }
            this.preYOffset = this.yOffset;
            if (this.yOffset < 0.0f) {
                this.yOffset += 0.0625f;
            }
            return;
        }
        if (this.charge >= ItemFirestoneRefined.item.func_77612_l()) {
            return;
        }
        if (this.clock % REBUILD_DELAY[this.rebuildDelay] == 0) {
            ++this.rebuildDelay;
            if (this.rebuildDelay >= REBUILD_DELAY.length) {
                this.rebuildDelay = REBUILD_DELAY.length - 1;
            }
            this.rebuildQueue();
        }
        if ((index = this.getNextLavaBlock(true)) != null && this.coolLava(index.x, index.y, index.z)) {
            ++this.charge;
            this.rebuildDelay = 0;
        }
    }

    private boolean coolLava(int x, int y, int z) {
        boolean placed;
        Block block = WorldPlugin.getBlock((IBlockAccess)this.field_145850_b, x, y, z);
        if (Fluids.LAVA.is(FluidHelper.getFluid(block)) && (placed = WorldPlugin.setBlock(this.field_145850_b, x, y, z, Blocks.field_150343_Z))) {
            EffectManager.instance.fireSparkEffect(this.field_145850_b, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.8, (double)this.field_145849_e + 0.5);
            this.queueAdjacent(x, y, z);
            this.expandQueue();
            return true;
        }
        return false;
    }

    private WorldCoordinate getNextLavaBlock(boolean remove) {
        if (this.queue.isEmpty()) {
            return null;
        }
        if (remove) {
            WorldCoordinate index = this.queue.pollFirst();
            return index;
        }
        return this.queue.peekFirst();
    }

    void rebuildQueue() {
        this.queue.clear();
        this.visitedBlocks.clear();
        this.lavaFound.clear();
        this.queueAdjacent(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.expandQueue();
    }

    private void expandQueue() {
        while (!this.lavaFound.isEmpty()) {
            Deque<WorldCoordinate> blocksToExpand = this.lavaFound;
            this.lavaFound = new LinkedList<WorldCoordinate>();
            for (WorldCoordinate index : blocksToExpand) {
                this.queueAdjacent(index.x, index.y, index.z);
            }
        }
    }

    public void queueAdjacent(int x, int y, int z) {
        this.queueForFilling(x + 1, y, z);
        this.queueForFilling(x - 1, y, z);
        this.queueForFilling(x, y, z + 1);
        this.queueForFilling(x, y, z - 1);
        this.queueForFilling(x, y + 1, z);
        this.queueForFilling(x, y - 1, z);
    }

    public void queueForFilling(int x, int y, int z) {
        WorldCoordinate index = new WorldCoordinate(0, x, y, z);
        if (this.visitedBlocks.add(index)) {
            if ((x - this.field_145851_c) * (x - this.field_145851_c) + (z - this.field_145849_e) * (z - this.field_145849_e) > 4096) {
                return;
            }
            Block block = WorldPlugin.getBlock((IBlockAccess)this.field_145850_b, x, y, z);
            if (block == Blocks.field_150343_Z || Fluids.LAVA.is(FluidHelper.getFluid(block))) {
                this.lavaFound.add(index);
                if (FluidHelper.isFullFluidBlock(block, this.field_145850_b, x, y, z)) {
                    this.queue.addLast(index);
                }
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74777_a("charge", (short)this.charge);
        data.func_74774_a("rebuildDelay", (byte)this.rebuildDelay);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.charge = data.func_74765_d("charge");
        this.rebuildDelay = data.func_74771_c("rebuildDelay");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public short getId() {
        return 222;
    }

    static {
        TileFirestoneRecharge.REBUILD_DELAY[0] = 128;
        TileFirestoneRecharge.REBUILD_DELAY[1] = 256;
        TileFirestoneRecharge.REBUILD_DELAY[2] = 512;
        TileFirestoneRecharge.REBUILD_DELAY[3] = 1024;
        TileFirestoneRecharge.REBUILD_DELAY[4] = 2048;
        TileFirestoneRecharge.REBUILD_DELAY[5] = 4096;
        TileFirestoneRecharge.REBUILD_DELAY[6] = 8192;
        TileFirestoneRecharge.REBUILD_DELAY[7] = 16384;
    }
}

