/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.List;
import mods.railcraft.common.blocks.hidden.BlockHidden;
import mods.railcraft.common.blocks.hidden.TrailTicker;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.ItemCircuit;
import mods.railcraft.common.items.ItemMaterials;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.plugins.forge.OreDictPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemGoggles
extends ItemArmor {
    private static final String TEXTURE = "railcraft:textures/entities/armor/goggles.png";
    private static ItemGoggles item;

    public static void registerItem() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "railcraft.armor.goggles")) {
            item = new ItemGoggles();
            item.func_77655_b(tag);
            ItemRegistry.registerItem((Item)item);
            RailcraftLanguage.instance().registerItemName((Object)item, tag);
            CraftingPlugin.addShapedOreRecipe(new ItemStack((Item)item), true, "GCG", "I I", "LLL", Character.valueOf('C'), ItemCircuit.getReceiverCircuit(), Character.valueOf('I'), "ingotSteel", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('G'), new ItemStack(Blocks.field_150410_aZ));
            ItemRegistry.registerItemStack(tag, new ItemStack((Item)item));
            BlockHidden.registerBlock();
            if (BlockHidden.getBlock() != null) {
                FMLCommonHandler.instance().bus().register((Object)new TrailTicker());
            }
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack((Item)item);
    }

    public static Aura getCurrentAura(ItemStack goggles) {
        NBTTagCompound data;
        Aura aura = Aura.NONE;
        if (goggles != null && goggles.func_77973_b() instanceof ItemGoggles && (data = goggles.func_77978_p()) != null) {
            aura = Aura.AURAS[data.func_74771_c("aura")];
        }
        return aura;
    }

    public static void incrementAura(ItemStack goggles) {
        if (goggles != null && goggles.func_77973_b() instanceof ItemGoggles) {
            NBTTagCompound data = goggles.func_77978_p();
            if (data == null) {
                data = new NBTTagCompound();
                goggles.func_77982_d(data);
            }
            byte aura = data.func_74771_c("aura");
            if ((aura = (byte)(aura + 1)) >= Aura.AURAS.length) {
                aura = 0;
            }
            data.func_74774_a("aura", aura);
        }
    }

    public static boolean areEnabled() {
        return item != null;
    }

    public static ItemStack getGoggles(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        ItemStack helm = player.func_82169_q(MiscTools.ArmorSlots.HELM.ordinal());
        if (helm != null && helm.func_77973_b() instanceof ItemGoggles) {
            return helm;
        }
        return null;
    }

    public static boolean isPlayerWearing(EntityPlayer player) {
        ItemStack helm = player.func_82169_q(MiscTools.ArmorSlots.HELM.ordinal());
        return helm != null && helm.func_77973_b() instanceof ItemGoggles;
    }

    public ItemGoggles() {
        super(ItemMaterials.GOGGLES, 0, 0);
        this.func_77637_a(CreativePlugin.RAILCRAFT_TAB);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(this.func_77658_a()));
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ItemGoggles.incrementAura(stack);
        if (Game.isNotHost(world)) {
            Aura aura = ItemGoggles.getCurrentAura(stack);
            ChatPlugin.sendLocalizedChat(player, "gui.goggles.mode", "\u00a75" + (Object)((Object)aura));
        }
        return stack.func_77946_l();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return TEXTURE;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return OreDictPlugin.isOreType("ingotSteel", stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        NBTTagCompound data = stack.func_77978_p();
        Aura aura = ItemGoggles.getCurrentAura(stack);
        String mode = RailcraftLanguage.translate("gui.goggles.mode");
        String tip = RailcraftLanguage.translate("gui.goggles.tip");
        list.add(String.format(mode, "\u00a75" + (Object)((Object)aura)));
        list.add(tip);
    }

    public static enum Aura {
        NONE("gui.goggles.aura.none"),
        ANCHOR("gui.goggles.aura.anchor"),
        TUNING("gui.goggles.aura.tuning"),
        TRACKING("gui.goggles.aura.tracking");

        public static final Aura[] AURAS;
        private final String name;

        private Aura(String name) {
            this.name = name;
        }

        public String toString() {
            return RailcraftLanguage.translate(this.name);
        }

        static {
            AURAS = Aura.values();
        }
    }
}

