/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.RailcraftPartItems;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import org.apache.logging.log4j.Level;

public class ItemGear
extends ItemRailcraft {
    private static ItemStack stoneGear;
    private static ItemStack ironGear;
    private static ItemGear itemGear;

    public ItemGear() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("railcraft.part.gear");
    }

    @Override
    public void func_94581_a(IIconRegister iconRegister) {
        for (EnumGear gear : EnumGear.VALUES) {
            gear.icon = iconRegister.func_94245_a("railcraft:part.gear." + gear.name().toLowerCase(Locale.ENGLISH).replace("_", "."));
        }
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(ItemGear.getGoldPlateGear());
        if (InvTools.isStackEqualToBlock(stoneGear, Blocks.field_150347_e)) {
            list.add(ItemGear.getIronGear());
        }
        list.add(ItemGear.getSteelGear());
    }

    public IIcon func_77617_a(int damage) {
        if (damage < 0 || damage >= EnumGear.VALUES.length) {
            return EnumGear.IRON.icon;
        }
        return EnumGear.VALUES[damage].icon;
    }

    private static void init() {
        if (itemGear == null) {
            String tag = "part.gear";
            itemGear = new ItemGear();
            ItemRegistry.registerItem(itemGear);
            for (EnumGear gear : EnumGear.values()) {
                ItemStack stack = new ItemStack((Item)itemGear, 1, gear.ordinal());
                RailcraftLanguage.instance().registerItemName(stack, itemGear.func_77667_c(stack));
                RailcraftPartItems.registerItem(itemGear.func_77667_c(stack), stack);
            }
        }
        if (stoneGear == null) {
            try {
                Class<?> buildcraftCore = Class.forName("buildcraft.BuildCraftCore");
                Field stoneGearItem = buildcraftCore.getField("stoneGearItem");
                stoneGear = new ItemStack((Item)stoneGearItem.get(null));
                Field ironGearItem = buildcraftCore.getField("ironGearItem");
                ironGear = new ItemStack((Item)ironGearItem.get(null));
            }
            catch (Exception ex) {
                Game.log(Level.INFO, "BuildcraftCore not found, using alternate gear recipes.", new Object[0]);
                stoneGear = new ItemStack(Blocks.field_150347_e);
                ironGear = new ItemStack((Item)itemGear, 1, EnumGear.IRON.ordinal());
                CraftingPlugin.addShapedRecipe(ironGear, " I ", "ISI", " I ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('S'), stoneGear);
            }
            CraftingPlugin.addShapedRecipe(new ItemStack((Item)itemGear, 1, EnumGear.GOLD_PLATE.ordinal()), " G ", "GSG", " G ", Character.valueOf('G'), new ItemStack(Items.field_151074_bl), Character.valueOf('S'), stoneGear);
            CraftingPlugin.addShapedOreRecipe(new ItemStack((Item)itemGear, 1, EnumGear.STEEL.ordinal()), " I ", "ISI", " I ", Character.valueOf('I'), "ingotSteel", Character.valueOf('S'), stoneGear);
        }
    }

    public static ItemStack getStoneGear() {
        ItemGear.init();
        return stoneGear.func_77946_l();
    }

    public static ItemStack getIronGear() {
        ItemGear.init();
        return ironGear.func_77946_l();
    }

    public static ItemStack getSteelGear() {
        ItemGear.init();
        return new ItemStack((Item)itemGear, 1, EnumGear.STEEL.ordinal());
    }

    public static ItemStack getGoldPlateGear() {
        return ItemGear.getGoldPlateGear(1);
    }

    public static ItemStack getGoldPlateGear(int qty) {
        ItemGear.init();
        return new ItemStack((Item)itemGear, qty, EnumGear.GOLD_PLATE.ordinal());
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77960_j();
        if (damage < 0 || damage >= EnumGear.VALUES.length) {
            return "";
        }
        switch (EnumGear.VALUES[damage]) {
            case GOLD_PLATE: {
                return "railcraft.part.gear.gold.plate";
            }
            case IRON: {
                return "railcraft.part.gear.iron";
            }
            case STEEL: {
                return "railcraft.part.gear.steel";
            }
        }
        return "";
    }

    static enum EnumGear {
        GOLD_PLATE,
        IRON,
        STEEL;

        public static final EnumGear[] VALUES;
        private IIcon icon;

        static {
            VALUES = EnumGear.values();
        }
    }
}

