/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.widgets;

import mods.railcraft.client.gui.GuiContainerRailcraft;
import mods.railcraft.client.render.FluidRenderer;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.gui.widgets.Widget;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;

public class FluidGaugeWidget
extends Widget {
    public final StandardTank tank;

    public FluidGaugeWidget(StandardTank tank, int x, int y, int u, int v, int w, int h) {
        super(x, y, u, v, w, h);
        this.tank = tank;
    }

    @Override
    public ToolTip getToolTip() {
        return this.tank.getToolTip();
    }

    @Override
    public void draw(GuiContainerRailcraft gui, int guiX, int guiY, int mouseX, int mouseY) {
        if (this.tank == null) {
            return;
        }
        FluidStack fluidStack = this.tank.getFluid();
        if (fluidStack == null || fluidStack.amount <= 0 || fluidStack.getFluid() == null) {
            return;
        }
        IIcon liquidIcon = FluidRenderer.getFluidTexture(fluidStack, false);
        if (liquidIcon == null) {
            return;
        }
        float scale = (float)Math.min(fluidStack.amount, this.tank.getCapacity()) / (float)this.tank.getCapacity();
        gui.bindTexture(FluidRenderer.getFluidSheet(fluidStack));
        for (int col = 0; col < this.w / 16; ++col) {
            for (int row = 0; row <= this.h / 16; ++row) {
                gui.func_94065_a(guiX + this.x + col * 16, guiY + this.y + row * 16 - 1, liquidIcon, 16, 16);
            }
        }
        gui.bindTexture(gui.texture);
        gui.func_73729_b(guiX + this.x, guiY + this.y - 1, this.x, this.y - 1, this.w, this.h - (int)Math.floor((float)this.h * scale) + 1);
        gui.func_73729_b(guiX + this.x, guiY + this.y, this.u, this.v, this.w, this.h);
    }
}

