/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderEnergyBase;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotEnergy;
import mods.railcraft.common.gui.slots.SlotUpgrade;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerEnergyLoader
extends RailcraftContainer {
    private TileLoaderEnergyBase device;
    private int lastEnergy;
    private int lastTransferRate;
    private short lastStorage;
    private short lastLapo;

    public ContainerEnergyLoader(InventoryPlayer inventoryplayer, TileLoaderEnergyBase device) {
        super(device);
        this.device = device;
        this.addSlot(new SlotEnergy(device, 0, 8, 17));
        this.addSlot(new SlotEnergy(device, 1, 8, 53));
        this.addSlot(new SlotUpgrade(device, 2, 152, 8));
        this.addSlot(new SlotUpgrade(device, 3, 152, 26));
        this.addSlot(new SlotUpgrade(device, 4, 152, 44));
        this.addSlot(new SlotUpgrade(device, 5, 152, 62));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, 142));
        }
    }

    @Override
    public void func_75132_a(ICrafting player) {
        super.func_75132_a(player);
        PacketBuilder.instance().sendGuiIntegerPacket((EntityPlayerMP)player, this.field_75152_c, 0, this.device.getEnergy());
        player.func_71112_a((Container)this, 1, (int)this.device.storageUpgrades);
        player.func_71112_a((Container)this, 2, (int)this.device.lapotronUpgrades);
        player.func_71112_a((Container)this, 3, this.device.transferRate);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting player = (ICrafting)this.field_75149_d.get(i);
            if (this.lastEnergy != this.device.getEnergy()) {
                PacketBuilder.instance().sendGuiIntegerPacket((EntityPlayerMP)player, this.field_75152_c, 0, this.device.getEnergy());
            }
            if (this.lastStorage != this.device.storageUpgrades) {
                player.func_71112_a((Container)this, 1, (int)this.device.storageUpgrades);
            }
            if (this.lastLapo != this.device.lapotronUpgrades) {
                player.func_71112_a((Container)this, 2, (int)this.device.lapotronUpgrades);
            }
            if (this.lastLapo == this.device.transferRate) continue;
            player.func_71112_a((Container)this, 3, this.device.transferRate);
        }
        this.lastEnergy = this.device.getEnergy();
        this.lastStorage = this.device.storageUpgrades;
        this.lastLapo = this.device.lapotronUpgrades;
        this.lastTransferRate = this.device.transferRate;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        if (id == 0) {
            this.device.setEnergy(data);
        }
        if (id == 1) {
            this.device.storageUpgrades = (short)data;
        }
        if (id == 2) {
            this.device.lapotronUpgrades = (short)data;
        }
        if (id == 3) {
            this.device.transferRate = data;
        }
    }
}

