/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.railcraft.client.particles.EntityDropParticleFX;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class BlockRailcraftFluid
extends BlockFluidClassic {
    protected float particleRed;
    protected float particleGreen;
    protected float particleBlue;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] theIcon;
    protected boolean flammable;
    protected int flammability = 0;
    private boolean hasFlowIcon = true;

    public BlockRailcraftFluid(Fluid fluid, Material material) {
        super(fluid, material);
        this.setDensity(fluid.getDensity());
    }

    public BlockRailcraftFluid setNoFlow() {
        this.hasFlowIcon = false;
        return this;
    }

    public IIcon func_149691_a(int side, int meta) {
        return side != 0 && side != 1 ? this.theIcon[1] : this.theIcon[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IIcon still;
        IIcon flowing = still = iconRegister.func_94245_a("railcraft:fluids/" + this.fluidName + "_still");
        if (this.hasFlowIcon) {
            flowing = iconRegister.func_94245_a("railcraft:fluids/" + this.fluidName + "_flow");
        }
        this.theIcon = new IIcon[]{still, flowing};
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        if (this.flammable && world.field_73011_w.field_76574_g == -1) {
            world.func_72885_a(null, (double)x, (double)y, (double)z, 4.0f, true, true);
            world.func_147468_f(x, y, z);
        }
    }

    public BlockRailcraftFluid setFlammable(boolean flammable) {
        this.flammable = flammable;
        return this;
    }

    public BlockRailcraftFluid setFlammability(int flammability) {
        this.flammability = flammability;
        return this;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.flammable ? 300 : 0;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.flammability;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.flammable;
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        return this.flammable && this.flammability == 0;
    }

    public BlockRailcraftFluid setParticleColor(float particleRed, float particleGreen, float particleBlue) {
        this.particleRed = particleRed;
        this.particleGreen = particleGreen;
        this.particleBlue = particleBlue;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        super.func_149734_b(world, x, y, z, rand);
        if (rand.nextInt(10) == 0 && World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && !world.func_147439_a(x, y - 2, z).func_149688_o().func_76230_c()) {
            double px = (float)x + rand.nextFloat();
            double py = (double)y - 1.05;
            double pz = (float)z + rand.nextFloat();
            EntityDropParticleFX fx = new EntityDropParticleFX(world, px, py, pz, this.particleRed, this.particleGreen, this.particleBlue);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }
}

