/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.emblems;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.net.HttpURLConnection;
import java.net.URL;
import mods.railcraft.common.emblems.EmblemManager;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.logging.log4j.Level;

public abstract class EmblemUnlocker {
    protected boolean isComplete = false;
    protected boolean emblemExists = false;
    protected final String unlockCode;
    protected final String identifier;
    protected final EntityPlayerMP player;

    private EmblemUnlocker(String unlockCode, EntityPlayerMP player) {
        this.unlockCode = unlockCode;
        this.player = player;
        this.identifier = EmblemManager.getIdentifierFromCode(unlockCode);
    }

    public static void spawnUnlocker(String unlockCode, int windowId, EntityPlayerMP player) {
        EmblemUnlockerGUI unlocker = new EmblemUnlockerGUI(unlockCode, player, windowId);
        super.initiateCheck();
        FMLCommonHandler.instance().bus().register((Object)unlocker);
    }

    private void initiateCheck() {
        Game.log(Level.INFO, "Attempting to unlock Emblem - \"emblem-{0}\"", this.identifier);
        EmblemChecker checker = new EmblemChecker();
        checker.setDaemon(true);
        checker.setName("Emblem downloader: " + this.identifier);
        checker.start();
    }

    protected void onComplete() {
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        if (this.isComplete) {
            this.onComplete();
            FMLCommonHandler.instance().bus().unregister((Object)this);
        }
    }

    private class EmblemChecker
    extends Thread {
        private EmblemChecker() {
        }

        @Override
        public void run() {
            EmblemUnlocker.this.emblemExists = this.emblemExists();
            EmblemUnlocker.this.isComplete = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean emblemExists() {
            HttpURLConnection con = null;
            try {
                HttpURLConnection.setFollowRedirects(false);
                URL url = new URL("https://dl.dropboxusercontent.com/u/38558957/Minecraft/Railcraft/Emblems/emblem-" + EmblemUnlocker.this.identifier + ".jar");
                con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("HEAD");
                boolean bl = con.getResponseCode() == 200;
                return bl;
            }
            catch (Exception ex) {
                Game.log(Level.WARN, "Failed to find Emblem: \"emblem-{0}\". Reason: {1}", EmblemUnlocker.this.identifier, ex);
                boolean bl = false;
                return bl;
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
    }

    private static class EmblemUnlockerGUI
    extends EmblemUnlocker {
        private final int windowId;

        private EmblemUnlockerGUI(String unlockCode, EntityPlayerMP player, int windowId) {
            super(unlockCode, player);
            this.windowId = windowId;
        }

        @Override
        protected void onComplete() {
            String result = "";
            String msg = "gui.engrave.unlock.fail";
            if (this.emblemExists) {
                EmblemManager.unlockEmblem(this.player, this.unlockCode);
                result = this.identifier;
                msg = "gui.engrave.unlock.success";
            }
            EmblemManager.updateUnlockGUI(this.player, result, this.windowId, msg);
        }
    }
}

