/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.List;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ItemCart;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemCartAnchor
extends ItemCart {
    public ItemCartAnchor(EnumCart cartType) {
        super(cartType);
    }

    public static long getFuel(ItemStack cart) {
        long fuel = 0L;
        NBTTagCompound nbt = cart.func_77978_p();
        if (nbt != null) {
            fuel = nbt.func_74763_f("fuel");
        }
        return fuel;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        if (this.getCartType() == EnumCart.ANCHOR && !RailcraftConfig.anchorFuelWorld.isEmpty() || this.getCartType() == EnumCart.ANCHOR_PERSONAL && !RailcraftConfig.anchorFuelPersonal.isEmpty()) {
            long fuel = ItemCartAnchor.getFuel(stack);
            double hours = (double)fuel / 72000.0;
            String format = RailcraftLanguage.translate("gui.anchor.fuel.remaining");
            info.add(String.format(format, hours));
        }
    }
}

