/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.carts.EntityCartAnchor;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ItemCart;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.util.collections.ItemMap;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityCartAnchorPersonal
extends EntityCartAnchor {
    private static final int MINUTES_BEFORE_DISABLE = 5;
    private long ticksSincePlayerLogged;

    public EntityCartAnchorPersonal(World world) {
        super(world);
    }

    public EntityCartAnchorPersonal(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    public void func_70071_h_() {
        if (this.ticket != null) {
            this.ticksSincePlayerLogged = Game.isPlayerConnected(CartTools.getCartOwner((EntityMinecart)this)) ? 0L : ++this.ticksSincePlayerLogged;
            if (this.ticksSincePlayerLogged > 6000L) {
                this.releaseTicket();
            }
        }
        super.func_70071_h_();
    }

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        return ItemCart.getCartType(stack) == EnumCart.ANCHOR_PERSONAL;
    }

    @Override
    protected ForgeChunkManager.Ticket getTicketFromForge() {
        return ForgeChunkManager.requestPlayerTicket((Object)Railcraft.getMod(), (String)CartTools.getCartOwner((EntityMinecart)this), (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
    }

    @Override
    public ItemMap<Integer> getFuelMap() {
        return RailcraftConfig.anchorFuelPersonal;
    }

    @Override
    protected boolean meetsTicketRequirements() {
        return Game.isPlayerConnected(CartTools.getCartOwner((EntityMinecart)this)) && super.meetsTicketRequirements();
    }

    @Override
    public int func_94098_o() {
        return EnumMachineAlpha.PERSONAL_ANCHOR.ordinal();
    }

    @Override
    public String func_145825_b() {
        return RailcraftLanguage.translate(EnumCart.ANCHOR_PERSONAL.getTag());
    }

    @Override
    public IIcon getBlockTextureOnSide(int side) {
        if (side < 2 && !this.func_70083_f(6)) {
            return EnumMachineAlpha.PERSONAL_ANCHOR.getTexture(6);
        }
        return EnumMachineAlpha.PERSONAL_ANCHOR.getTexture(side);
    }
}

