/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks.speedcontroller;

import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.common.blocks.tracks.TrackSpeed;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.blocks.tracks.speedcontroller.SpeedController;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class SpeedControllerHighSpeed
extends SpeedController {
    private static final int LOOK_AHEAD_DIST = 2;
    private static final float SPEED_SLOPE = 0.45f;
    private static SpeedController instance;

    public static SpeedController getInstance() {
        if (instance == null) {
            instance = new SpeedControllerHighSpeed();
        }
        return instance;
    }

    @Override
    public float getMaxSpeed(ITrackInstance track, EntityMinecart cart) {
        Float speed = null;
        if (track instanceof TrackSpeed) {
            speed = ((TrackSpeed)track).maxSpeed;
        }
        if (speed == null) {
            speed = Float.valueOf(SpeedControllerHighSpeed.speedForCurrentTrack(track));
        }
        if (track instanceof TrackSpeed) {
            ((TrackSpeed)track).maxSpeed = speed;
        }
        return speed.floatValue();
    }

    public static float speedForCurrentTrack(ITrackInstance track) {
        int meta;
        int z;
        int y;
        int x;
        World world = track.getWorld();
        Block block = WorldPlugin.getBlock((IBlockAccess)world, x = track.getX(), y = track.getY(), z = track.getZ());
        if (TrackTools.isRailBlock(block) && (meta = TrackTools.getTrackMeta(world, block, null, x, y, z)) > 1 && meta < 6) {
            return 0.45f;
        }
        return SpeedControllerHighSpeed.speedForNextTrack(world, x, y, z, 0);
    }

    private static float speedForNextTrack(World world, int x, int y, int z, int dist) {
        float maxSpeed = RailcraftConfig.getMaxHighSpeed();
        if (dist < 2) {
            for (int side = 2; side < 6; ++side) {
                int zz;
                int yy;
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                int xx = MiscTools.getXOnSide(x, dir);
                Block block = WorldPlugin.getBlock((IBlockAccess)world, xx, yy = y, zz = MiscTools.getZOnSide(z, dir));
                if (!TrackTools.isRailBlock(block)) {
                    block = WorldPlugin.getBlock((IBlockAccess)world, xx, yy + 1, zz);
                    if (TrackTools.isRailBlock(block)) {
                        ++yy;
                    } else {
                        block = WorldPlugin.getBlock((IBlockAccess)world, xx, yy - 1, zz);
                        if (TrackTools.isRailBlock(block)) {
                            --yy;
                        }
                    }
                }
                if (!TrackTools.isRailBlock(block)) continue;
                int meta = TrackTools.getTrackMeta(world, block, null, xx, yy, zz);
                if (meta > 1 && meta < 6) {
                    return 0.45f;
                }
                maxSpeed = SpeedControllerHighSpeed.speedForNextTrack(world, xx, yy, zz, dist + 1);
                if (maxSpeed != 0.45f) continue;
                return 0.45f;
            }
        }
        return maxSpeed;
    }
}

