/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.api.tracks.ITrackSwitch;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackSwitchBase;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TrackSwitch
extends TrackSwitchBase
implements ITrackReversable {
    private boolean reversed;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.SWITCH;
    }

    @Override
    public IIcon getIcon() {
        int index = 0;
        if (this.reversed) {
            index += 2;
        }
        if (this.isSwitched()) {
            ++index;
        }
        return this.getIcon(index);
    }

    @Override
    public int getBasicRailMetadata(EntityMinecart cart) {
        int meta = this.tileEntity.func_145832_p();
        if (cart != null && this.isSwitched()) {
            if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
                meta = this.isMirrored() ? (this.reversed ? EnumTrackMeta.WEST_SOUTH_CORNER.ordinal() : EnumTrackMeta.WEST_NORTH_CORNER.ordinal()) : (this.reversed ? EnumTrackMeta.EAST_NORTH_CORNER.ordinal() : EnumTrackMeta.EAST_SOUTH_CORNER.ordinal());
            } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
                meta = this.isMirrored() ? (this.reversed ? EnumTrackMeta.WEST_NORTH_CORNER.ordinal() : EnumTrackMeta.EAST_NORTH_CORNER.ordinal()) : (this.reversed ? EnumTrackMeta.EAST_SOUTH_CORNER.ordinal() : EnumTrackMeta.WEST_SOUTH_CORNER.ordinal());
            }
        }
        return meta;
    }

    @Override
    protected boolean shouldLockSwitch() {
        int x = this.tileEntity.field_145851_c;
        int y = this.tileEntity.field_145848_d;
        int z = this.tileEntity.field_145849_e;
        int meta = this.tileEntity.func_145832_p();
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            z = this.isReversed() != this.isMirrored() ? ++z : --z;
        } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            x = !this.isReversed() != this.isMirrored() ? ++x : --x;
        }
        return CartTools.isMinecartOnRailAt(this.getWorld(), x, y, z, 0.3f);
    }

    @Override
    protected boolean shouldSpringSwitch() {
        int x = this.tileEntity.field_145851_c;
        int y = this.tileEntity.field_145848_d;
        int z = this.tileEntity.field_145849_e;
        int meta = this.tileEntity.func_145832_p();
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            x = this.isMirrored() ? --x : ++x;
        } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            z = this.isMirrored() ? --z : ++z;
        }
        return CartTools.isMinecartOnRailAt(this.getWorld(), x, y, z, 0.3f);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("Reversed", this.reversed);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.reversed = data.func_74767_n("Reversed");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.reversed = data.readBoolean();
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public AxisAlignedBB getRoutingSearchBox() {
        ForgeDirection side = ForgeDirection.SOUTH;
        if (this.tileEntity.func_145832_p() == 1) {
            side = this.isReversed() != this.isMirrored() ? ForgeDirection.WEST : ForgeDirection.EAST;
        } else if (this.isReversed() != this.isMirrored()) {
            side = ForgeDirection.NORTH;
        }
        AxisAlignedBB box = AxisAlignedBB.func_72332_a().func_72299_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        box = MiscTools.addCoordToAABB(box, side.offsetX, 0.0, side.offsetZ);
        box = MiscTools.addCoordToAABB(box, side.offsetX + 1, 1.0, side.offsetZ + 1);
        box = box.func_72317_d((double)this.getX(), (double)this.getY(), (double)this.getZ());
        return box;
    }

    @Override
    public ITrackSwitch.ArrowDirection getRedSignDirection() {
        if (this.tileEntity.func_145832_p() == 1) {
            if (this.isSwitched()) {
                if (this.isMirrored()) {
                    return ITrackSwitch.ArrowDirection.NORTH;
                }
                return ITrackSwitch.ArrowDirection.SOUTH;
            }
            if (this.isReversed() != this.isMirrored()) {
                return ITrackSwitch.ArrowDirection.WEST;
            }
            return ITrackSwitch.ArrowDirection.EAST;
        }
        if (this.isSwitched()) {
            if (this.isMirrored()) {
                return ITrackSwitch.ArrowDirection.EAST;
            }
            return ITrackSwitch.ArrowDirection.WEST;
        }
        if (this.isReversed() != this.isMirrored()) {
            return ITrackSwitch.ArrowDirection.NORTH;
        }
        return ITrackSwitch.ArrowDirection.SOUTH;
    }

    @Override
    public ITrackSwitch.ArrowDirection getWhiteSignDirection() {
        if (this.tileEntity.func_145832_p() == 1) {
            if (this.isSwitched()) {
                return ITrackSwitch.ArrowDirection.EAST_WEST;
            }
            return ITrackSwitch.ArrowDirection.NORTH_SOUTH;
        }
        if (this.isSwitched()) {
            return ITrackSwitch.ArrowDirection.NORTH_SOUTH;
        }
        return ITrackSwitch.ArrowDirection.EAST_WEST;
    }
}

