/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.IRoutableCart;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.IRoutingTrack;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackSecured;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class TrackRouting
extends TrackSecured
implements ITrackPowered,
IRoutingTrack {
    private StandaloneInventory inv = new StandaloneInventory(1);
    private boolean powered = false;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.ROUTING;
    }

    public IInventory getInventory() {
        return this.inv;
    }

    @Override
    public IIcon getIcon() {
        if (this.isPowered()) {
            return this.getIcon(0);
        }
        return this.getIcon(1);
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        IToolCrowbar crowbar;
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.func_77973_b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            GuiHandler.openGui(EnumGui.TRACK_ROUTING, player, this.getWorld(), this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (!this.isPowered()) {
            return;
        }
        if (this.inv.func_70301_a(0) == null) {
            return;
        }
        if (cart instanceof IRoutableCart) {
            ((IRoutableCart)cart).setDestination(this.inv.func_70301_a(0));
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("powered", this.powered);
        this.inv.writeToNBT("inv", data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.func_74767_n("powered");
        this.inv.readFromNBT("inv", data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean p = data.readBoolean();
        if (p != this.powered) {
            this.powered = p;
            this.markBlockNeedsUpdate();
        }
    }

    @Override
    public boolean setTicket(String dest, String title, String owner) {
        ItemStack ticket = ItemTicket.getTicket();
        return ItemTicket.setTicketData(ticket, dest, title, owner);
    }

    @Override
    public void clearTicket() {
        this.inv.func_70299_a(0, null);
    }

    @Override
    public void onBlockRemoved() {
        super.onBlockRemoved();
        InvTools.dropInventory(this.inv, this.tileEntity.func_145831_w(), this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
    }
}

