/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.tracks.TrackRegistry;
import mods.railcraft.api.tracks.TrackSpec;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.blocks.tracks.TrackBoarding;
import mods.railcraft.common.blocks.tracks.TrackBoardingTrain;
import mods.railcraft.common.blocks.tracks.TrackBufferStop;
import mods.railcraft.common.blocks.tracks.TrackControl;
import mods.railcraft.common.blocks.tracks.TrackCoupler;
import mods.railcraft.common.blocks.tracks.TrackDefault;
import mods.railcraft.common.blocks.tracks.TrackDetectorDirection;
import mods.railcraft.common.blocks.tracks.TrackDisembark;
import mods.railcraft.common.blocks.tracks.TrackDisposal;
import mods.railcraft.common.blocks.tracks.TrackEmbarking;
import mods.railcraft.common.blocks.tracks.TrackGated;
import mods.railcraft.common.blocks.tracks.TrackGatedOneWay;
import mods.railcraft.common.blocks.tracks.TrackHolding;
import mods.railcraft.common.blocks.tracks.TrackHoldingTrain;
import mods.railcraft.common.blocks.tracks.TrackJunction;
import mods.railcraft.common.blocks.tracks.TrackLauncher;
import mods.railcraft.common.blocks.tracks.TrackLimiter;
import mods.railcraft.common.blocks.tracks.TrackLockdown;
import mods.railcraft.common.blocks.tracks.TrackLockdownTrain;
import mods.railcraft.common.blocks.tracks.TrackLocomotive;
import mods.railcraft.common.blocks.tracks.TrackNextGenLocking;
import mods.railcraft.common.blocks.tracks.TrackOneWay;
import mods.railcraft.common.blocks.tracks.TrackPriming;
import mods.railcraft.common.blocks.tracks.TrackReinforced;
import mods.railcraft.common.blocks.tracks.TrackReinforcedBooster;
import mods.railcraft.common.blocks.tracks.TrackReinforcedJunction;
import mods.railcraft.common.blocks.tracks.TrackReinforcedSwitch;
import mods.railcraft.common.blocks.tracks.TrackReinforcedWye;
import mods.railcraft.common.blocks.tracks.TrackRouting;
import mods.railcraft.common.blocks.tracks.TrackSlow;
import mods.railcraft.common.blocks.tracks.TrackSlowBooster;
import mods.railcraft.common.blocks.tracks.TrackSlowJunction;
import mods.railcraft.common.blocks.tracks.TrackSlowSwitch;
import mods.railcraft.common.blocks.tracks.TrackSlowWye;
import mods.railcraft.common.blocks.tracks.TrackSpeed;
import mods.railcraft.common.blocks.tracks.TrackSpeedBoost;
import mods.railcraft.common.blocks.tracks.TrackSpeedSwitch;
import mods.railcraft.common.blocks.tracks.TrackSpeedTransition;
import mods.railcraft.common.blocks.tracks.TrackSpeedWye;
import mods.railcraft.common.blocks.tracks.TrackSuspended;
import mods.railcraft.common.blocks.tracks.TrackSwitch;
import mods.railcraft.common.blocks.tracks.TrackTextureLoader;
import mods.railcraft.common.blocks.tracks.TrackWhistle;
import mods.railcraft.common.blocks.tracks.TrackWye;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.items.ItemCrowbar;
import mods.railcraft.common.items.ItemPlate;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.items.ItemTicketGold;
import mods.railcraft.common.items.RailcraftPartItems;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public enum EnumTrack {
    BOARDING(ModuleManager.Module.TRACKS, 4, 1, "boarding", 8, TrackBoarding.class),
    HOLDING(ModuleManager.Module.TRACKS, 2, 1, "holding", 8, TrackHolding.class),
    ONEWAY(ModuleManager.Module.TRACKS, 4, 1, "oneway", 8, TrackOneWay.class),
    CONTROL(ModuleManager.Module.TRACKS, 2, 0, "control", 16, TrackControl.class),
    LAUNCHER(ModuleManager.Module.EXTRAS, 2, 1, "launcher", 1, TrackLauncher.class),
    PRIMING(ModuleManager.Module.EXTRAS, 2, 1, "priming", 8, TrackPriming.class),
    JUNCTION(ModuleManager.Module.TRACKS, 1, 0, "junction", 8, TrackJunction.class),
    SWITCH(ModuleManager.Module.SIGNALS, 4, 0, "switch", 8, TrackSwitch.class),
    DISEMBARK(ModuleManager.Module.TRACKS, 4, 1, "disembarking", 8, TrackDisembark.class),
    SUSPENDED(ModuleManager.Module.EXTRAS, 1, 0, "suspended", 8, TrackSuspended.class),
    GATED_ONEWAY(ModuleManager.Module.TRACKS, 2, 0, "gated.oneway", 4, TrackGatedOneWay.class),
    GATED(ModuleManager.Module.TRACKS, 1, 0, "gated", 4, TrackGated.class),
    SLOW(ModuleManager.Module.TRACKS_WOOD, 2, 0, "slow", 16, TrackSlow.class),
    SLOW_BOOSTER(ModuleManager.Module.TRACKS_WOOD, 2, 1, "slow.boost", 8, TrackSlowBooster.class),
    SLOW_JUNCTION(ModuleManager.Module.TRACKS_WOOD, 1, 0, "slow.junction", 8, TrackSlowJunction.class),
    SLOW_SWITCH(ModuleManager.Module.SIGNALS, 4, 0, "slow.switch", 8, TrackSlowSwitch.class),
    SPEED(ModuleManager.Module.TRACKS_HIGHSPEED, 2, 0, "speed", 16, TrackSpeed.class),
    SPEED_BOOST(ModuleManager.Module.TRACKS_HIGHSPEED, 2, 1, "speed.boost", 8, TrackSpeedBoost.class),
    SPEED_TRANSITION(ModuleManager.Module.TRACKS_HIGHSPEED, 4, 1, "speed.transition", 8, TrackSpeedTransition.class),
    SPEED_SWITCH(ModuleManager.Module.SIGNALS, 4, 0, "speed.switch", 8, TrackSpeedSwitch.class),
    BOARDING_TRAIN(ModuleManager.Module.TRAIN, 4, 1, "boarding.train", 8, TrackBoardingTrain.class),
    HOLDING_TRAIN(ModuleManager.Module.TRAIN, 2, 1, "holding.train", 8, TrackHoldingTrain.class),
    COUPLER(ModuleManager.Module.TRACKS, 4, 1, "coupler", 8, TrackCoupler.class),
    DECOUPLER(ModuleManager.Module.TRACKS, 0, 0, "decoupler", 8, TrackCoupler.class),
    REINFORCED(ModuleManager.Module.TRACKS_REINFORCED, 2, 0, "reinforced", 16, TrackReinforced.class),
    REINFORCED_BOOSTER(ModuleManager.Module.TRACKS_REINFORCED, 2, 1, "reinforced.boost", 8, TrackReinforcedBooster.class),
    REINFORCED_JUNCTION(ModuleManager.Module.TRACKS_REINFORCED, 1, 0, "reinforced.junction", 8, TrackReinforcedJunction.class),
    REINFORCED_SWITCH(ModuleManager.Module.TRACKS_REINFORCED, 4, 0, "reinforced.switch", 8, TrackReinforcedSwitch.class),
    BUFFER_STOP(ModuleManager.Module.TRACKS, 2, 0, "buffer.stop", 8, TrackBufferStop.class),
    DISPOSAL(ModuleManager.Module.TRACKS, 1, 0, "disposal", 8, TrackDisposal.class),
    DETECTOR_DIRECTION(ModuleManager.Module.TRACKS, 4, 0, "detector.direction", 8, TrackDetectorDirection.class),
    EMBARKING(ModuleManager.Module.TRACKS, 2, 1, "embarking", 8, TrackEmbarking.class),
    WYE(ModuleManager.Module.TRACKS, 2, 0, "wye", 8, TrackWye.class),
    SLOW_WYE(ModuleManager.Module.TRACKS, 2, 0, "slow.wye", 8, TrackSlowWye.class),
    REINFORCED_WYE(ModuleManager.Module.TRACKS, 2, 0, "reinforced.wye", 8, TrackReinforcedWye.class),
    SPEED_WYE(ModuleManager.Module.TRACKS, 2, 0, "speed.wye", 8, TrackSpeedWye.class),
    LOCKDOWN(ModuleManager.Module.TRACKS, 2, 1, "lockdown", 8, TrackLockdown.class),
    LOCKDOWN_TRAIN(ModuleManager.Module.TRAIN, 2, 1, "lockdown.train", 8, TrackLockdownTrain.class),
    WHISTLE(ModuleManager.Module.LOCOMOTIVES, 2, 1, "whistle", 8, TrackWhistle.class),
    LOCOMOTIVE(ModuleManager.Module.LOCOMOTIVES, 6, 3, "locomotive", 8, TrackLocomotive.class),
    LIMITER(ModuleManager.Module.LOCOMOTIVES, 5, 4, "limiter", 8, TrackLimiter.class),
    ROUTING(ModuleManager.Module.ROUTING, 2, 1, "routing", 8, TrackRouting.class),
    LOCKING(ModuleManager.Module.TRACKS, 16, 1, "locking", 8, TrackNextGenLocking.class);

    private final ModuleManager.Module module;
    private final String tag;
    private final int recipeOutput;
    private final int numIcons;
    private final int itemIconIndex;
    private TrackSpec trackSpec;
    private boolean depreciated;
    private final Class<? extends TrackBaseRailcraft> trackInstance;
    private static final List<EnumTrack> creativeList;
    public static final EnumTrack[] VALUES;

    private EnumTrack(ModuleManager.Module module, int numIcons, int itemIconIndex, String tag, int recipeOutput, Class<? extends TrackBaseRailcraft> trackInstance) {
        this.module = module;
        this.numIcons = numIcons;
        this.itemIconIndex = itemIconIndex;
        this.tag = tag;
        this.recipeOutput = recipeOutput;
        this.trackInstance = trackInstance;
    }

    public void initialize() {
        ToolTip toolTip = ToolTip.buildToolTip(this.getTag() + ".tip", new String[0]);
        List<String> tips = toolTip != null ? toolTip.convertToStrings() : null;
        try {
            this.trackSpec = new TrackSpec((short)this.ordinal(), this.getTag(), TrackTextureLoader.INSTANCE, this.trackInstance, tips);
        }
        catch (Throwable error) {
            Game.logErrorAPI("Railcraft", error, TrackSpec.class);
            this.trackSpec = new TrackSpec((short)this.ordinal(), this.getTag(), TrackTextureLoader.INSTANCE, this.trackInstance);
        }
        TrackRegistry.registerTrackSpec(this.trackSpec);
        this.registerRecipe();
    }

    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(this.module) && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    public boolean isDepreciated() {
        return this.depreciated;
    }

    public ItemStack getItem() {
        return this.getItem(1);
    }

    public ItemStack getItem(int qty) {
        return this.getTrackSpec().getItem(qty);
    }

    public TrackSpec getTrackSpec() {
        return this.trackSpec;
    }

    public String getTextureTag() {
        return "railcraft:tracks/track." + this.tag;
    }

    public String getTag() {
        return "railcraft:track." + this.tag;
    }

    public int getNumIcons() {
        return this.numIcons;
    }

    public int getItemIconIndex() {
        return this.itemIconIndex;
    }

    public static EnumTrack fromId(int id) {
        if (id < 0 || id >= EnumTrack.values().length) {
            id = 0;
        }
        return EnumTrack.values()[id];
    }

    public static List<EnumTrack> getCreativeList() {
        return creativeList;
    }

    private ItemStack registerRecipe() {
        if (this.getItem() == null) {
            return null;
        }
        ItemStack output = this.getItem(this.recipeOutput * 2);
        String railWood = RailcraftConfig.useOldRecipes() ? "slabWood" : RailcraftPartItems.getRailWood();
        ItemStack railStandard = RailcraftConfig.useOldRecipes() ? new ItemStack(Items.field_151042_j) : RailcraftPartItems.getRailStandard();
        ItemStack railAdvanced = RailcraftConfig.useOldRecipes() ? new ItemStack(Items.field_151043_k) : RailcraftPartItems.getRailAdvanced();
        String railSpeed = RailcraftConfig.useOldRecipes() ? "ingotSteel" : RailcraftPartItems.getRailSpeed();
        String railReinforced = RailcraftConfig.useOldRecipes() || !EnumMachineAlpha.ROCK_CRUSHER.isEnabled() ? "ingotSteel" : RailcraftPartItems.getRailReinforced();
        ItemStack woodTie = RailcraftPartItems.getTieWood();
        ItemStack woodRailbed = RailcraftPartItems.getRailbedWood();
        ItemStack stoneRailbed = RailcraftPartItems.getRailbedStone();
        ItemStack reinforcedRailbed = RailcraftConfig.useOldRecipes() ? new ItemStack(Blocks.field_150343_Z) : RailcraftPartItems.getRailbedStone();
        ItemStack crowbar = ItemCrowbar.getItem();
        if (crowbar != null) {
            crowbar.func_77964_b(-1);
        }
        switch (this) {
            case LOCKING: {
                CraftingPlugin.addShapedOreRecipe(output, "IrI", "IbI", "IsI", Character.valueOf('I'), railAdvanced, Character.valueOf('s'), woodRailbed, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), Blocks.field_150456_au);
                break;
            }
            case ONEWAY: {
                CraftingPlugin.addShapedOreRecipe(output, "IbI", "IsI", "IpI", Character.valueOf('I'), railStandard, Character.valueOf('s'), woodRailbed, Character.valueOf('b'), Blocks.field_150456_au, Character.valueOf('p'), Blocks.field_150331_J);
                break;
            }
            case CONTROL: {
                CraftingPlugin.addShapedOreRecipe(output, "IrI", "GsG", "IrI", Character.valueOf('I'), railStandard, Character.valueOf('G'), railAdvanced, Character.valueOf('s'), woodRailbed, Character.valueOf('r'), Items.field_151137_ax);
                break;
            }
            case SPEED: {
                CraftingPlugin.addShapedOreRecipe(output, "I I", "IsI", "I I", Character.valueOf('I'), railSpeed, Character.valueOf('s'), stoneRailbed);
                break;
            }
            case SPEED_BOOST: {
                CraftingPlugin.addShapedOreRecipe(output, "IrI", "IsI", "IrI", Character.valueOf('I'), railSpeed, Character.valueOf('s'), stoneRailbed, Character.valueOf('r'), Items.field_151137_ax);
                break;
            }
            case SPEED_TRANSITION: {
                CraftingPlugin.addShapedOreRecipe(output, "IrI", "IrI", "IsI", Character.valueOf('I'), railSpeed, Character.valueOf('s'), stoneRailbed, Character.valueOf('r'), Items.field_151137_ax);
                CraftingPlugin.addShapedOreRecipe(output, "IsI", "IrI", "IrI", Character.valueOf('I'), railSpeed, Character.valueOf('s'), stoneRailbed, Character.valueOf('r'), Items.field_151137_ax);
                break;
            }
            case SPEED_SWITCH: {
                CraftingPlugin.addShapedOreRecipe(output, "IsI", "III", "III", Character.valueOf('I'), railSpeed, Character.valueOf('s'), stoneRailbed);
                break;
            }
            case LAUNCHER: {
                CraftingPlugin.addShapedOreRecipe(output, "IsI", "BPB", "IsI", Character.valueOf('I'), railReinforced, Character.valueOf('B'), "blockSteel", Character.valueOf('s'), stoneRailbed, Character.valueOf('P'), Blocks.field_150331_J);
                break;
            }
            case PRIMING: {
                CraftingPlugin.addShapedOreRecipe(output, "IpI", "IsI", "IfI", Character.valueOf('I'), railReinforced, Character.valueOf('s'), stoneRailbed, Character.valueOf('p'), Blocks.field_150456_au, Character.valueOf('f'), Items.field_151033_d);
                break;
            }
            case JUNCTION: {
                CraftingPlugin.addShapedOreRecipe(output, "III", "I#I", "III", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed);
                break;
            }
            case SLOW: {
                CraftingPlugin.addShapedOreRecipe(output, "I I", "I#I", "I I", Character.valueOf('I'), railWood, Character.valueOf('#'), woodRailbed);
                break;
            }
            case SLOW_BOOSTER: {
                CraftingPlugin.addShapedOreRecipe(output, "I I", "G#G", "IrI", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('I'), railWood, Character.valueOf('#'), woodRailbed, Character.valueOf('r'), Items.field_151137_ax);
                break;
            }
            case SLOW_SWITCH: {
                CraftingPlugin.addShapedOreRecipe(output, "I#I", "III", "III", Character.valueOf('I'), railWood, Character.valueOf('#'), woodRailbed);
                break;
            }
            case SLOW_JUNCTION: {
                CraftingPlugin.addShapedOreRecipe(output, "III", "I#I", "III", Character.valueOf('I'), railWood, Character.valueOf('#'), woodRailbed);
                break;
            }
            case SWITCH: {
                CraftingPlugin.addShapedOreRecipe(output, "I#I", "III", "III", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed);
                break;
            }
            case WYE: {
                CraftingPlugin.addShapedOreRecipe(output, "III", "II#", "III", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed);
                break;
            }
            case SLOW_WYE: {
                CraftingPlugin.addShapedOreRecipe(output, "III", "II#", "III", Character.valueOf('I'), railWood, Character.valueOf('#'), woodRailbed);
                break;
            }
            case REINFORCED_WYE: {
                CraftingPlugin.addShapedOreRecipe(output, "III", "II#", "III", Character.valueOf('I'), railReinforced, Character.valueOf('#'), reinforcedRailbed);
                break;
            }
            case SPEED_WYE: {
                CraftingPlugin.addShapedOreRecipe(output, "III", "II#", "III", Character.valueOf('I'), railSpeed, Character.valueOf('#'), stoneRailbed);
                break;
            }
            case DISEMBARK: {
                CraftingPlugin.addShapedOreRecipe(output, "IpI", "I#I", "IrI", Character.valueOf('I'), railAdvanced, Character.valueOf('#'), woodRailbed, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('p'), Blocks.field_150456_au);
                break;
            }
            case EMBARKING: {
                CraftingPlugin.addShapedOreRecipe(output, "IpI", "I#I", "IpI", Character.valueOf('I'), railAdvanced, Character.valueOf('#'), woodRailbed, Character.valueOf('p'), Items.field_151079_bi);
                break;
            }
            case SUSPENDED: {
                CraftingPlugin.addShapedOreRecipe(output, "ItI", "ItI", "ItI", Character.valueOf('I'), railStandard, Character.valueOf('t'), woodTie);
                break;
            }
            case DISPOSAL: {
                CraftingPlugin.addShapedOreRecipe(output, "ItI", "IPI", "ItI", Character.valueOf('I'), railStandard, Character.valueOf('P'), ItemPlate.getPlate(ItemPlate.EnumPlate.STEEL), Character.valueOf('t'), woodTie);
                break;
            }
            case BUFFER_STOP: {
                CraftingPlugin.addShapedOreRecipe(output, "I I", "I#I", "IbI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('b'), Blocks.field_150339_S);
                break;
            }
            case DETECTOR_DIRECTION: {
                CraftingPlugin.addShapedOreRecipe(output, "IrI", "I#I", "IsI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('s'), Blocks.field_150456_au);
                break;
            }
            case GATED: {
                CraftingPlugin.addShapedOreRecipe(output, "IgI", "I#I", "IgI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('g'), Blocks.field_150396_be);
                break;
            }
            case GATED_ONEWAY: {
                CraftingPlugin.addShapedOreRecipe(output, "IgI", "G#G", "IgI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('g'), Blocks.field_150396_be, Character.valueOf('G'), railAdvanced);
                break;
            }
            case COUPLER: {
                CraftingPlugin.addShapedOreRecipe(output, "IcI", "I#I", "IcI", Character.valueOf('I'), railAdvanced, Character.valueOf('#'), woodRailbed, Character.valueOf('c'), crowbar);
                break;
            }
            case WHISTLE: {
                CraftingPlugin.addShapedOreRecipe(output, "IyI", "I#I", "IbI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('y'), "dyeYellow", Character.valueOf('b'), "dyeBlack");
                break;
            }
            case LOCOMOTIVE: {
                CraftingPlugin.addShapedOreRecipe(output, "IlI", "I#I", "IlI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('l'), RailcraftPartItems.getSignalLamp());
                break;
            }
            case LIMITER: {
                CraftingPlugin.addShapedOreRecipe(output, "IlI", "I#I", "IlI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('l'), Items.field_151107_aW);
                break;
            }
            case ROUTING: {
                CraftingPlugin.addShapedOreRecipe(output, "IrI", "I#I", "ItI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('t'), ItemTicket.getTicket());
                CraftingPlugin.addShapedOreRecipe(output, "IrI", "I#I", "ItI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('t'), ItemTicketGold.getTicket());
                break;
            }
            case REINFORCED: {
                CraftingPlugin.addShapedOreRecipe(output, "I I", "I#I", "I I", Character.valueOf('I'), railReinforced, Character.valueOf('#'), reinforcedRailbed);
                break;
            }
            case REINFORCED_BOOSTER: {
                CraftingPlugin.addShapedOreRecipe(output, "I I", "I#I", "IrI", Character.valueOf('I'), railReinforced, Character.valueOf('r'), new ItemStack(Items.field_151137_ax), Character.valueOf('#'), reinforcedRailbed);
                break;
            }
            case REINFORCED_JUNCTION: {
                CraftingPlugin.addShapedOreRecipe(output, "III", "I#I", "III", Character.valueOf('I'), railReinforced, Character.valueOf('#'), reinforcedRailbed);
                break;
            }
            case REINFORCED_SWITCH: {
                CraftingPlugin.addShapedOreRecipe(output, "I#I", "III", "III", Character.valueOf('I'), railReinforced, Character.valueOf('#'), reinforcedRailbed);
            }
        }
        return output;
    }

    static {
        creativeList = new ArrayList<EnumTrack>(50);
        VALUES = EnumTrack.values();
        TrackRegistry.registerIconLoader(TrackTextureLoader.INSTANCE);
        TrackRegistry.registerTrackSpec(new TrackSpec(-1, "railcraft:default", null, TrackDefault.class));
        creativeList.add(SWITCH);
        creativeList.add(WYE);
        creativeList.add(JUNCTION);
        creativeList.add(CONTROL);
        creativeList.add(LOCKING);
        creativeList.add(DISEMBARK);
        creativeList.add(EMBARKING);
        creativeList.add(COUPLER);
        creativeList.add(DECOUPLER);
        creativeList.add(WHISTLE);
        creativeList.add(LOCOMOTIVE);
        creativeList.add(LIMITER);
        creativeList.add(ROUTING);
        creativeList.add(BUFFER_STOP);
        creativeList.add(ONEWAY);
        creativeList.add(DETECTOR_DIRECTION);
        creativeList.add(GATED_ONEWAY);
        creativeList.add(GATED);
        creativeList.add(SUSPENDED);
        creativeList.add(DISPOSAL);
        creativeList.add(SLOW);
        creativeList.add(SLOW_BOOSTER);
        creativeList.add(SLOW_JUNCTION);
        creativeList.add(SLOW_SWITCH);
        creativeList.add(SLOW_WYE);
        creativeList.add(REINFORCED);
        creativeList.add(REINFORCED_BOOSTER);
        creativeList.add(REINFORCED_JUNCTION);
        creativeList.add(REINFORCED_SWITCH);
        creativeList.add(REINFORCED_WYE);
        creativeList.add(SPEED);
        creativeList.add(SPEED_BOOST);
        creativeList.add(SPEED_TRANSITION);
        creativeList.add(SPEED_SWITCH);
        creativeList.add(SPEED_WYE);
        creativeList.add(PRIMING);
        creativeList.add(LAUNCHER);
        EnumTrack.DECOUPLER.depreciated = true;
        EnumTrack.LOCKDOWN.depreciated = true;
        EnumTrack.LOCKDOWN_TRAIN.depreciated = true;
        EnumTrack.BOARDING.depreciated = true;
        EnumTrack.BOARDING_TRAIN.depreciated = true;
        EnumTrack.HOLDING.depreciated = true;
        EnumTrack.HOLDING_TRAIN.depreciated = true;
    }
}

