/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.api.core.ITextureLoader;
import mods.railcraft.api.tracks.ITrackBlocksMovement;
import mods.railcraft.api.tracks.ITrackCustomShape;
import mods.railcraft.api.tracks.ITrackEmitter;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.TrackRegistry;
import mods.railcraft.api.tracks.TrackSpec;
import mods.railcraft.client.particles.ParticleHelper;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TileTrackTESR;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public class BlockTrack
extends BlockRailBase
implements IPostConnection {
    protected final int renderType;

    public BlockTrack(int modelID) {
        super(false);
        this.renderType = modelID;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.func_149752_b(3.5f);
        this.func_149711_c(1.05f);
        this.func_149672_a(field_149777_j);
        this.func_149647_a(CreativeTabs.field_78029_e);
        GameRegistry.registerTileEntity(TileTrack.class, (String)"RailcraftTrackTile");
        GameRegistry.registerTileEntity(TileTrackTESR.class, (String)"RailcraftTrackTESRTile");
        try {
            TrackSpec.blockTrack = this;
        }
        catch (Throwable error) {
            Game.logErrorAPI(Railcraft.getModId(), error, TrackSpec.class);
        }
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        Map<Short, TrackSpec> specs = TrackRegistry.getTrackSpecIDs();
        HashSet<TrackSpec> railcraftSpecs = new HashSet<TrackSpec>();
        for (EnumTrack track : EnumTrack.getCreativeList()) {
            TrackSpec spec = specs.get((short)track.ordinal());
            if (spec == null) continue;
            railcraftSpecs.add(spec);
            if (!track.isEnabled() || track.isDepreciated()) continue;
            list.add(spec.getItem());
        }
        HashSet<TrackSpec> otherSpecs = new HashSet<TrackSpec>(specs.values());
        otherSpecs.removeAll(railcraftSpecs);
        otherSpecs.remove(TrackRegistry.getTrackSpec("Railcraft:default"));
        for (TrackSpec spec : otherSpecs) {
            list.add(spec.getItem());
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileTrack) {
            ITrackInstance track = ((TileTrack)tile).getTrackInstance();
            return new ItemStack((Block)this, 1, (int)track.getTrackSpec().getTrackId());
        }
        return null;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        return false;
    }

    public int func_149645_b() {
        return this.renderType;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public int func_149656_h() {
        return 0;
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        ITrackInstance track;
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackCustomShape) {
            return ((ITrackCustomShape)track).getCollisionBoundingBoxFromPool();
        }
        return null;
    }

    public AxisAlignedBB func_149633_g(World world, int i, int j, int k) {
        ITrackInstance track;
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackCustomShape) {
            return ((ITrackCustomShape)track).getSelectedBoundingBoxFromPool();
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)i + this.field_149759_B, (double)j + this.field_149760_C, (double)k + this.field_149754_D, (double)i + this.field_149755_E, (double)j + this.field_149756_F, (double)k + this.field_149757_G);
    }

    public boolean func_149662_c() {
        return false;
    }

    public MovingObjectPosition func_149731_a(World world, int i, int j, int k, Vec3 vec3d, Vec3 vec3d1) {
        ITrackInstance track;
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackCustomShape) {
            return ((ITrackCustomShape)track).collisionRayTrace(vec3d, vec3d1);
        }
        return super.func_149731_a(world, i, j, k, vec3d, vec3d1);
    }

    public void func_149719_a(IBlockAccess iblockaccess, int i, int j, int k) {
        int l = iblockaccess.func_72805_g(i, j, k);
        if (l >= 2 && l <= 5) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    public boolean func_149655_b(IBlockAccess world, int x, int y, int z) {
        ITrackInstance track;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackBlocksMovement) {
            return !((ITrackBlocksMovement)((Object)track)).blocksMovement();
        }
        return super.func_149655_b(world, x, y, z);
    }

    public boolean func_149742_c(World world, int i, int j, int k) {
        return !TrackTools.isRailBlockAt(world, i, j + 1, k);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileTrack) {
            ITrackInstance track = ((TileTrack)tile).getTrackInstance();
            return track instanceof ITrackEmitter;
        }
        return false;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileTrack) {
            ITrackInstance track = ((TileTrack)tile).getTrackInstance();
            return track instanceof ITrackEmitter ? ((ITrackEmitter)track).getPowerOutput() : 0;
        }
        return 0;
    }

    public void onMinecartPass(World world, EntityMinecart cart, int i, int j, int k) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileTrack) {
            ((TileTrack)tile).getTrackInstance().onMinecartPass(cart);
        }
    }

    public int getBasicRailMetadata(IBlockAccess world, EntityMinecart cart, int i, int j, int k) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getBasicRailMetadata(cart);
        }
        return world.func_72805_g(i, j, k);
    }

    public float getRailMaxSpeed(World world, EntityMinecart cart, int i, int j, int k) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getRailMaxSpeed(cart);
        }
        return 0.4f;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int side, float u1, float u2, float u3) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().blockActivated(player);
        }
        return false;
    }

    public boolean isFlexibleRail(IBlockAccess world, int i, int j, int k) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().isFlexibleRail();
        }
        return false;
    }

    public boolean canMakeSlopes(IBlockAccess world, int i, int j, int k) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().canMakeSlopes();
        }
        return true;
    }

    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150448_aq.func_149691_a(side, meta);
    }

    public IIcon func_149673_e(IBlockAccess world, int i, int j, int k, int side) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getIcon();
        }
        return null;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        for (ITextureLoader iconLoader : TrackRegistry.getIconLoaders()) {
            iconLoader.registerIcons(iconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addHitEffects(worldObj, RailcraftBlocks.getBlockTrack(), target, effectRenderer, null);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addDestroyEffects(worldObj, RailcraftBlocks.getBlockTrack(), x, y, z, meta, effectRenderer, null);
    }

    public ArrayList<ItemStack> getDrops(World world, int i, int j, int k, int md, int fortune) {
        TileEntity tile = world.func_147438_o(i, j, k);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (tile instanceof TileTrack) {
            items.add(new ItemStack((Block)this, 1, (int)((TileTrack)tile).getTrackInstance().getTrackSpec().getTrackId()));
        } else {
            Game.log(Level.WARN, "Rail Tile was invalid when harvesting rail", new Object[0]);
            items.add(new ItemStack(Blocks.field_150448_aq));
        }
        return items;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public TileEntity getBlockEntity(int md) {
        return null;
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileTrack) {
            ((TileTrack)tile).onBlockPlacedBy(entityliving);
            ((TileTrack)tile).getTrackInstance().onBlockPlacedBy(entityliving);
        }
    }

    public void func_149714_e(World world, int i, int j, int k, int meta) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileTrack) {
            ((TileTrack)tile).getTrackInstance().onBlockPlaced();
        }
    }

    public void func_149636_a(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71064_a(StatList.field_75934_C[BlockTrack.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
        if (Game.isHost(world) && !player.field_71075_bZ.field_75098_d) {
            this.func_149697_b(world, x, y, z, 0, 0);
        }
        return world.func_147468_f(x, y, z);
    }

    public void func_149749_a(World world, int i, int j, int k, Block block, int meta) {
        super.func_149749_a(world, i, j, k, block, meta);
        try {
            TileEntity tile = world.func_147438_o(i, j, k);
            if (tile instanceof TileTrack) {
                ((TileTrack)tile).getTrackInstance().onBlockRemoved();
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("Railcraft", error, ITrackInstance.class);
        }
        world.func_147475_p(i, j, k);
    }

    public void func_149695_a(World world, int i, int j, int k, Block block) {
        if (Game.isNotHost(world)) {
            return;
        }
        TileEntity t = world.func_147438_o(i, j, k);
        if (t instanceof TileTrack) {
            TileTrack tile = (TileTrack)t;
            tile.getTrackInstance().onNeighborBlockChange(block);
        }
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileTrack) {
            try {
                return ((TileTrack)tile).getTrackInstance().getHardness();
            }
            catch (Throwable error) {
                Game.logErrorAPI("Railcraft", error, ITrackInstance.class);
            }
        }
        return super.func_149712_f(world, x, y, z);
    }

    public float getExplosionResistance(Entity exploder, World world, int x, int y, int z, double srcX, double srcY, double srcZ) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getExplosionResistance(srcX, srcY, srcZ, exploder) * 3.0f / 5.0f;
        }
        return this.func_149638_a(exploder);
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    @Override
    public IPostConnection.ConnectStyle connectsToPost(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        ITrackInstance track;
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof IPostConnection) {
            return ((IPostConnection)((Object)track)).connectsToPost(world, i, j, k, side);
        }
        return IPostConnection.ConnectStyle.NONE;
    }
}

