/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SimpleSignalController;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.ISignalBlockTile;
import mods.railcraft.common.blocks.signals.ISignalTile;
import mods.railcraft.common.blocks.signals.SignalBlock;
import mods.railcraft.common.blocks.signals.SignalBlockSimple;
import mods.railcraft.common.blocks.signals.TileSignalBase;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.nbt.NBTTagCompound;

public class TileSignalBlockSignal
extends TileSignalBase
implements IControllerTile,
ISignalTile,
ISignalBlockTile {
    private final SimpleSignalController controller = new SimpleSignalController(this.getName(), this);
    private final SignalBlock signalBlock = new SignalBlockSimple(this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BLOCK_SIGNAL;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.field_145850_b)) {
            this.controller.tickClient();
            this.signalBlock.tickClient();
            return;
        }
        this.controller.tickServer();
        this.signalBlock.tickServer();
        SignalAspect prevAspect = this.controller.getAspect();
        if (this.controller.isBeingPaired()) {
            this.controller.setAspect(SignalAspect.BLINK_YELLOW);
        } else {
            this.controller.setAspect(this.signalBlock.getSignalAspect());
        }
        if (prevAspect != this.controller.getAspect()) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public SignalAspect getSignalAspect() {
        return this.controller.getAspect();
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.signalBlock.writeToNBT(data);
        this.controller.writeToNBT(data);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.signalBlock.readFromNBT(data);
        this.controller.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.controller.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.controller.readPacketData(data);
    }

    @Override
    public SimpleSignalController getController() {
        return this.controller;
    }

    @Override
    public SignalBlock getSignalBlock() {
        return this.signalBlock;
    }
}

