/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SimpleSignalController;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileBoxController
extends TileBoxBase
implements IControllerTile,
IGuiReturnHandler {
    private boolean powered;
    public SignalAspect defaultAspect = SignalAspect.GREEN;
    public SignalAspect poweredAspect = SignalAspect.RED;
    private boolean prevBlinkState;
    private final SimpleSignalController controller = new SimpleSignalController(this.getName(), this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_CONTROLLER;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (player.func_70093_af()) {
            return false;
        }
        GuiHandler.openGui(EnumGui.BOX_CONTROLLER, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.field_145850_b)) {
            this.controller.tickClient();
            if (this.controller.getAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.markBlockForUpdate();
            }
            return;
        }
        this.controller.tickServer();
        SignalAspect prevAspect = this.controller.getAspect();
        if (this.controller.isBeingPaired()) {
            this.controller.setAspect(SignalAspect.BLINK_YELLOW);
        } else if (this.controller.isPaired()) {
            this.controller.setAspect(this.determineAspect());
        } else {
            this.controller.setAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.controller.getAspect()) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        boolean p;
        super.onNeighborBlockChange(block);
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean bl = p = this.isBeingPowered() || PowerPlugin.isRedstonePowered(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (p != this.powered) {
            this.powered = p;
            this.sendUpdateToClient();
        }
    }

    private boolean isBeingPowered() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (side == ForgeDirection.UP || this.tileCache.getTileOnSide(side) instanceof TileBoxBase) continue;
            if (PowerPlugin.isBlockBeingPowered(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side)) {
                return true;
            }
            if (!PowerPlugin.isBlockBeingPowered(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, side)) continue;
            return true;
        }
        return false;
    }

    private SignalAspect determineAspect() {
        SignalAspect newAspect = this.powered ? this.poweredAspect : this.defaultAspect;
        for (int side = 2; side < 6; ++side) {
            TileBoxBase tile;
            ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side);
            TileEntity t = this.tileCache.getTileOnSide(forgeSide);
            if (!(t instanceof TileBoxBase) || !(tile = (TileBoxBase)t).canTransferAspect()) continue;
            newAspect = SignalAspect.mostRestrictive(newAspect, tile.getBoxSignalAspect(forgeSide.getOpposite()));
        }
        return newAspect;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74757_a("Powered", this.powered);
        data.func_74768_a("defaultAspect", this.defaultAspect.ordinal());
        data.func_74768_a("PoweredAspect", this.poweredAspect.ordinal());
        this.controller.writeToNBT(data);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.powered = data.func_74767_n("Powered");
        this.defaultAspect = SignalAspect.values()[data.func_74762_e("defaultAspect")];
        this.poweredAspect = SignalAspect.values()[data.func_74762_e("PoweredAspect")];
        this.controller.readFromNBT(data);
        if (data.func_74764_b("ReceiverX")) {
            int x = data.func_74762_e("ReceiverX");
            int y = data.func_74762_e("ReceiverY");
            int z = data.func_74762_e("ReceiverZ");
            this.controller.registerLegacyReceiver(x, y, z);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.defaultAspect.ordinal());
        data.writeByte(this.poweredAspect.ordinal());
        this.controller.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.defaultAspect = SignalAspect.values()[data.readByte()];
        this.poweredAspect = SignalAspect.values()[data.readByte()];
        this.controller.readPacketData(data);
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.defaultAspect.ordinal());
        data.writeByte(this.poweredAspect.ordinal());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.defaultAspect = SignalAspect.values()[data.readByte()];
        this.poweredAspect = SignalAspect.values()[data.readByte()];
    }

    @Override
    public boolean isConnected(ForgeDirection side) {
        TileEntity tile = this.tileCache.getTileOnSide(side);
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canTransferAspect();
        }
        return false;
    }

    @Override
    public SignalAspect getBoxSignalAspect(ForgeDirection side) {
        return this.controller.getAspect();
    }

    @Override
    public boolean canReceiveAspect() {
        return true;
    }

    @Override
    public SimpleSignalController getController() {
        return this.controller;
    }
}

