/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.util.HashMap;
import java.util.Map;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.signals.SignalBlock;

public class SignalBlockRelay
extends SignalBlock {
    private final Map<WorldCoordinate, SignalAspect> aspects = new HashMap<WorldCoordinate, SignalAspect>();

    public SignalBlockRelay(RailcraftTileEntity tile) {
        super(tile, 2);
    }

    @Override
    protected void updateSignalAspect() {
        this.aspects.keySet().retainAll(this.pairings);
        for (WorldCoordinate otherCoord : this.pairings) {
            this.aspects.put(otherCoord, this.determineAspect(otherCoord));
        }
    }

    @Override
    public SignalAspect getSignalAspect() {
        if (this.isWaitingForRetest() || this.isBeingPaired()) {
            return SignalAspect.BLINK_YELLOW;
        }
        if (!this.isPaired()) {
            return SignalAspect.BLINK_RED;
        }
        SignalAspect aspect = SignalAspect.GREEN;
        for (WorldCoordinate otherCoord : this.pairings) {
            aspect = SignalAspect.mostRestrictive(aspect, this.aspects.get(otherCoord));
        }
        return aspect;
    }

    @Override
    protected SignalAspect getSignalAspectForPair(WorldCoordinate otherCoord) {
        SignalAspect aspect = SignalAspect.GREEN;
        for (Map.Entry<WorldCoordinate, SignalAspect> entry : this.aspects.entrySet()) {
            if (entry.getKey().equals(otherCoord)) continue;
            aspect = SignalAspect.mostRestrictive(aspect, entry.getValue());
        }
        return aspect;
    }
}

