/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import ic2.api.item.IBoxable;
import java.util.List;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SignalReceiver;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.items.ItemCircuit;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ItemSignalTuner
extends Item
implements IBoxable,
IActivationBlockingItem {
    private static Item item;

    public static void registerItem() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "railcraft.tool.signal.tuner")) {
            item = new ItemSignalTuner();
            RailcraftLanguage.instance().registerItemName(item, tag);
            ItemRegistry.registerItem(item);
            CraftingPlugin.addShapedRecipe(new ItemStack(item), " T ", "BRB", "   ", Character.valueOf('B'), Blocks.field_150430_aB, Character.valueOf('R'), ItemCircuit.getReceiverCircuit(), Character.valueOf('T'), Blocks.field_150429_aA);
            ItemRegistry.registerItemStack(tag, new ItemStack(item));
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack(item);
    }

    private ItemSignalTuner() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77655_b("railcraft.tool.signal.tuner");
        this.func_77637_a(CreativePlugin.RAILCRAFT_TAB);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(this.func_77658_a()));
    }

    public void func_150895_a(Item item, CreativeTabs tag, List list) {
        list.add(new ItemStack((Item)this));
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int i, int j, int k, int side, float par8, float par9, float par10) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile != null) {
            WorldCoordinate cPos = null;
            NBTTagCompound data = item.func_77978_p();
            if (data != null) {
                int cDim = data.func_74762_e("controllerDim");
                int cx = data.func_74762_e("controllerX");
                int cy = data.func_74762_e("controllerY");
                int cz = data.func_74762_e("controllerZ");
                cPos = new WorldCoordinate(cDim, cx, cy, cz);
            }
            if (tile instanceof IReceiverTile && cPos != null) {
                if (Game.isHost(world)) {
                    SignalReceiver receiver = ((IReceiverTile)tile).getReceiver();
                    if (i != cPos.x || j != cPos.y || k != cPos.z) {
                        tile = world.func_147438_o(cPos.x, cPos.y, cPos.z);
                        if (tile != null && tile instanceof IControllerTile) {
                            SignalController controller = ((IControllerTile)tile).getController();
                            if (receiver.getTile() != controller.getTile()) {
                                controller.registerReceiver(receiver);
                                controller.endPairing();
                                ChatPlugin.sendLocalizedChat(player, "gui.tuner.success", controller.getName(), receiver.getName());
                                item.func_77982_d(null);
                                return true;
                            }
                        } else if (world.func_72899_e(cPos.x, cPos.y, cPos.z)) {
                            ChatPlugin.sendLocalizedChat(player, "gui.tuner.abandon.gone", new Object[0]);
                            item.func_77982_d(null);
                        } else {
                            ChatPlugin.sendLocalizedChat(player, "gui.tuner.abandon.chunk", new Object[0]);
                            item.func_77982_d(null);
                        }
                    }
                }
            } else if (tile instanceof IControllerTile) {
                if (Game.isHost(world)) {
                    SignalController controller = ((IControllerTile)tile).getController();
                    if (cPos == null || i != cPos.x || j != cPos.y || k != cPos.z) {
                        ChatPlugin.sendLocalizedChat(player, "gui.tuner.start", controller.getName());
                        this.setControllerData(item, tile);
                        controller.startPairing();
                    } else {
                        ChatPlugin.sendLocalizedChat(player, "gui.tuner.stop", controller.getName());
                        controller.endPairing();
                        item.func_77982_d(null);
                    }
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private void setControllerData(ItemStack item, TileEntity tile) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("controllerDim", tile.func_145831_w().field_73011_w.field_76574_g);
        data.func_74768_a("controllerX", tile.field_145851_c);
        data.func_74768_a("controllerY", tile.field_145848_d);
        data.func_74768_a("controllerZ", tile.field_145849_e);
        item.func_77982_d(data);
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }
}

