/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import ic2.api.item.IBoxable;
import java.util.List;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.common.blocks.signals.ISignalBlockTile;
import mods.railcraft.common.blocks.signals.SignalBlock;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ItemSignalBlockSurveyor
extends Item
implements IBoxable,
IActivationBlockingItem {
    private static Item item;

    public static void registerItem() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "railcraft.tool.surveyor")) {
            item = new ItemSignalBlockSurveyor();
            ItemRegistry.registerItem(item);
            RailcraftLanguage.instance().registerItemName(item, tag);
            CraftingPlugin.addShapedRecipe(new ItemStack(item), " C ", "BGB", " R ", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('C'), Items.field_151111_aL, Character.valueOf('B'), Blocks.field_150430_aB, Character.valueOf('R'), Items.field_151137_ax);
            ItemRegistry.registerItemStack(tag, new ItemStack(item));
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack(item);
    }

    private ItemSignalBlockSurveyor() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77655_b("railcraft.tool.surveyor");
        this.func_77637_a(CreativePlugin.RAILCRAFT_TAB);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(this.func_77658_a()));
    }

    public void func_150895_a(Item item, CreativeTabs tag, List list) {
        list.add(new ItemStack((Item)this));
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            if (tile instanceof ISignalBlockTile) {
                if (Game.isHost(world)) {
                    WorldCoordinate track;
                    ISignalBlockTile signalTile = (ISignalBlockTile)tile;
                    SignalBlock signalBlock = signalTile.getSignalBlock();
                    WorldCoordinate pos = null;
                    NBTTagCompound data = item.func_77978_p();
                    if (data != null) {
                        int sDim = data.func_74762_e("signalDim");
                        int sx = data.func_74762_e("signalX");
                        int sy = data.func_74762_e("signalY");
                        int sz = data.func_74762_e("signalZ");
                        pos = new WorldCoordinate(sDim, sx, sy, sz);
                    }
                    if ((track = signalBlock.getTrackLocation()) == null) {
                        ChatPlugin.sendLocalizedChat(player, "gui.surveyor.track", signalTile.getName());
                    } else if (pos == null) {
                        ChatPlugin.sendLocalizedChat(player, "gui.surveyor.begin", new Object[0]);
                        this.setSignalData(item, tile);
                        signalBlock.startPairing();
                    } else if (x != pos.x || y != pos.y || z != pos.z) {
                        tile = world.func_147438_o(pos.x, pos.y, pos.z);
                        if (tile != null && tile instanceof ISignalBlockTile) {
                            ISignalBlockTile otherTile = (ISignalBlockTile)tile;
                            SignalBlock otherSignal = otherTile.getSignalBlock();
                            if (otherSignal != signalBlock && signalBlock.createSignalBlock(otherSignal)) {
                                ChatPlugin.sendLocalizedChat(player, "gui.surveyor.success", new Object[0]);
                                item.func_77982_d(null);
                            } else {
                                ChatPlugin.sendLocalizedChat(player, "gui.surveyor.invalid", new Object[0]);
                            }
                        } else if (world.func_72899_e(pos.x, pos.y, pos.z)) {
                            ChatPlugin.sendLocalizedChat(player, "gui.surveyor.lost", new Object[0]);
                            signalBlock.endPairing();
                            item.func_77982_d(null);
                        } else {
                            ChatPlugin.sendLocalizedChat(player, "gui.surveyor.unloaded", new Object[0]);
                        }
                    } else {
                        ChatPlugin.sendLocalizedChat(player, "gui.surveyor.abandon", new Object[0]);
                        signalBlock.endPairing();
                        item.func_77982_d(null);
                    }
                }
                return true;
            }
            if (Game.isHost(world)) {
                ChatPlugin.sendLocalizedChat(player, "gui.surveyor.wrong", new Object[0]);
            }
        }
        return false;
    }

    private void setSignalData(ItemStack item, TileEntity tile) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("signalDim", tile.func_145831_w().field_73011_w.field_76574_g);
        data.func_74768_a("signalX", tile.field_145851_c);
        data.func_74768_a("signalY", tile.field_145848_d);
        data.func_74768_a("signalZ", tile.field_145849_e);
        item.func_77982_d(data);
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }
}

