/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.signals.TileBoxBlockRelay;
import mods.railcraft.common.blocks.signals.TileBoxCapacitor;
import mods.railcraft.common.blocks.signals.TileBoxController;
import mods.railcraft.common.blocks.signals.TileBoxInterlock;
import mods.railcraft.common.blocks.signals.TileBoxReceiver;
import mods.railcraft.common.blocks.signals.TileBoxSequencer;
import mods.railcraft.common.blocks.signals.TileSignalBlockSignal;
import mods.railcraft.common.blocks.signals.TileSignalDistantSignal;
import mods.railcraft.common.blocks.signals.TileSignalDualHeadBlockSignal;
import mods.railcraft.common.blocks.signals.TileSignalDualHeadDistantSignal;
import mods.railcraft.common.blocks.signals.TileSignalFoundation;
import mods.railcraft.common.blocks.signals.TileSwitchLever;
import mods.railcraft.common.blocks.signals.TileSwitchMotor;
import mods.railcraft.common.blocks.signals.TileSwitchRouting;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.modules.ModuleManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public enum EnumSignal {
    BOX_INTERLOCK(ModuleManager.Module.SIGNALS, 3.0f, true, "box.interlock", TileBoxInterlock.class),
    DUAL_HEAD_BLOCK_SIGNAL(ModuleManager.Module.SIGNALS, 8.0f, false, "block.signal.dual", TileSignalDualHeadBlockSignal.class),
    SWITCH_MOTOR(ModuleManager.Module.SIGNALS, 8.0f, true, "switch.motor", TileSwitchMotor.class),
    BLOCK_SIGNAL(ModuleManager.Module.SIGNALS, 8.0f, false, "block.signal", TileSignalBlockSignal.class),
    SWITCH_LEVER(ModuleManager.Module.SIGNALS, 8.0f, true, "switch.lever", TileSwitchLever.class),
    SWITCH_ROUTING(ModuleManager.Module.ROUTING, 8.0f, true, "switch.routing", TileSwitchRouting.class),
    BOX_SEQUENCER(ModuleManager.Module.SIGNALS, 3.0f, false, "box.sequencer", TileBoxSequencer.class),
    BOX_CAPACITOR(ModuleManager.Module.SIGNALS, 3.0f, true, "box.capacitor", TileBoxCapacitor.class),
    BOX_RECEIVER(ModuleManager.Module.SIGNALS, 3.0f, true, "box.receiver", TileBoxReceiver.class),
    BOX_CONTROLLER(ModuleManager.Module.SIGNALS, 3.0f, true, "box.controller", TileBoxController.class),
    DISTANT_SIGNAL(ModuleManager.Module.SIGNALS, 8.0f, false, "distant", TileSignalDistantSignal.class),
    DUAL_HEAD_DISTANT_SIGNAL(ModuleManager.Module.SIGNALS, 8.0f, false, "distant.dual", TileSignalDualHeadDistantSignal.class),
    BOX_BLOCK_RELAY(ModuleManager.Module.SIGNALS, 3.0f, true, "box.block.relay", TileBoxBlockRelay.class);

    private final ModuleManager.Module module;
    private final float hardness;
    private final boolean needsSupport;
    private final String tag;
    private final Class<? extends TileSignalFoundation> tile;
    private IIcon icon;
    private static final List<EnumSignal> creativeList;
    public static final EnumSignal[] VALUES;

    private EnumSignal(ModuleManager.Module module, float hardness, boolean needsSupport, String tag, Class<? extends TileSignalFoundation> tile) {
        this.module = module;
        this.hardness = hardness;
        this.needsSupport = needsSupport;
        this.tile = tile;
        this.tag = tag;
    }

    public ItemStack getItem() {
        return this.getItem(1);
    }

    public ItemStack getItem(int qty) {
        return new ItemStack(RailcraftBlocks.getBlockSignal(), qty, this.ordinal());
    }

    public String getTag() {
        return "railcraft.signal." + this.tag;
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    public Class<? extends TileSignalFoundation> getTileClass() {
        return this.tile;
    }

    public TileSignalFoundation getBlockEntity() {
        if (this.tile == null) {
            return null;
        }
        try {
            return this.tile.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public float getHardness() {
        return this.hardness;
    }

    public void setIcon(IIcon icon) {
        this.icon = icon;
    }

    public IIcon getIcon() {
        return this.icon;
    }

    public static EnumSignal fromId(int id) {
        if (id < 0 || id >= VALUES.length) {
            return SWITCH_LEVER;
        }
        return VALUES[id];
    }

    public static List<EnumSignal> getCreativeList() {
        return creativeList;
    }

    public boolean needsSupport() {
        return this.needsSupport;
    }

    public boolean isEnabled() {
        if (this.module == null) {
            return false;
        }
        return ModuleManager.isModuleLoaded(this.getModule()) && RailcraftBlocks.getBlockSignal() != null && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    static {
        creativeList = new ArrayList<EnumSignal>();
        VALUES = EnumSignal.values();
        creativeList.add(SWITCH_LEVER);
        creativeList.add(SWITCH_MOTOR);
        creativeList.add(SWITCH_ROUTING);
        creativeList.add(BLOCK_SIGNAL);
        creativeList.add(DISTANT_SIGNAL);
        creativeList.add(DUAL_HEAD_BLOCK_SIGNAL);
        creativeList.add(DUAL_HEAD_DISTANT_SIGNAL);
        creativeList.add(BOX_BLOCK_RELAY);
        creativeList.add(BOX_CONTROLLER);
        creativeList.add(BOX_RECEIVER);
        creativeList.add(BOX_CAPACITOR);
        creativeList.add(BOX_SEQUENCER);
        creativeList.add(BOX_INTERLOCK);
    }
}

