/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.ore;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import java.util.Random;
import mods.railcraft.common.blocks.ore.BlockOre;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockWorldLogic
extends Block {
    private static BlockWorldLogic instance;

    public static BlockWorldLogic getBlock() {
        return instance;
    }

    public static void registerBlock() {
        if (instance == null && RailcraftConfig.isBlockEnabled("worldlogic")) {
            instance = new BlockWorldLogic();
            GameRegistry.registerBlock((Block)instance, (String)instance.func_149739_a());
            RailcraftLanguage.instance().registerItemName(new ItemStack((Block)instance), "ore.saltpeter.gen");
        }
    }

    public BlockWorldLogic() {
        super(Material.field_151576_e);
        this.func_149663_c("railcraft.worldlogic");
        this.func_149752_b(6000000.0f);
        this.func_149722_s();
        this.func_149672_a(Block.field_149769_e);
        this.func_149647_a(CreativePlugin.RAILCRAFT_TAB);
        this.func_149649_H();
        this.func_149675_a(true);
    }

    public void func_149651_a(IIconRegister iconRegister) {
    }

    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150357_h.func_149691_a(side, meta);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        if (MiscTools.getRand().nextInt(32) != 0) {
            return;
        }
        BlockOre blockOre = BlockOre.getBlock();
        if (blockOre == null || !EnumOre.SALTPETER.isEnabled() || !RailcraftConfig.isWorldGenEnabled("saltpeter")) {
            return;
        }
        int surfaceY = world.func_72825_h(x, z) - 2;
        if (surfaceY < 50 || surfaceY > 100) {
            return;
        }
        Block block = WorldPlugin.getBlock((IBlockAccess)world, x, surfaceY, z);
        if (block != Blocks.field_150354_m) {
            return;
        }
        Block above = WorldPlugin.getBlock((IBlockAccess)world, x, surfaceY + 1, z);
        if (above != Blocks.field_150354_m) {
            return;
        }
        Block below = WorldPlugin.getBlock((IBlockAccess)world, x, surfaceY - 1, z);
        if (below != Blocks.field_150354_m && below != Blocks.field_150322_A) {
            return;
        }
        int airCount = 0;
        BlockOre ore = BlockOre.getBlock();
        for (ForgeDirection side : EnumSet.of(ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST)) {
            boolean isAir = world.func_147437_c(MiscTools.getXOnSide(x, side), MiscTools.getYOnSide(surfaceY, side), MiscTools.getZOnSide(z, side));
            if (isAir) {
                ++airCount;
            }
            if (airCount > 1) {
                return;
            }
            if (isAir || (block = WorldPlugin.getBlockOnSide((IBlockAccess)world, x, surfaceY, z, side)) == Blocks.field_150354_m || block == Blocks.field_150322_A || block == ore) continue;
            return;
        }
        world.func_147465_d(x, surfaceY, z, (Block)ore, EnumOre.SALTPETER.ordinal(), 3);
    }

    public int func_149738_a(World world) {
        return 6000;
    }
}

