/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.ore;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.railcraft.client.particles.ParticleHelper;
import mods.railcraft.client.particles.ParticleHelperCallback;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.blocks.ore.ItemOre;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.ItemDust;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.HarvestPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class BlockOre
extends Block {
    public static int renderPass;
    private final int renderType;
    private final Random rand = new Random();
    private static BlockOre instance;
    private static final ParticleHelperCallback callback;

    public static BlockOre getBlock() {
        return instance;
    }

    public static void registerBlock() {
        if (instance == null && RailcraftConfig.isBlockEnabled("ore")) {
            int renderId = Railcraft.getProxy().getRenderId();
            instance = new BlockOre(renderId);
            GameRegistry.registerBlock((Block)instance, ItemOre.class, (String)instance.func_149739_a());
            EntityTunnelBore.addMineableBlock(instance);
            block3: for (EnumOre ore : EnumOre.values()) {
                RailcraftLanguage.instance().registerItemName(ore.getItem(), ore.getTag());
                ForestryPlugin.addBackpackItem("miner", ore.getItem());
                switch (ore) {
                    case FIRESTONE: {
                        HarvestPlugin.setHarvestLevel(instance, ore.ordinal(), "pickaxe", 3);
                        continue block3;
                    }
                    default: {
                        HarvestPlugin.setHarvestLevel(instance, ore.ordinal(), "pickaxe", 2);
                    }
                }
            }
            ItemDust.getDust(ItemDust.EnumDust.SULFUR);
            ItemDust.getDust(ItemDust.EnumDust.SALTPETER);
            OreDictionary.registerOre((String)"oreSulfur", (ItemStack)EnumOre.SULFUR.getItem());
            OreDictionary.registerOre((String)"oreSaltpeter", (ItemStack)EnumOre.SALTPETER.getItem());
            OreDictionary.registerOre((String)"oreDiamond", (ItemStack)EnumOre.DARK_DIAMOND.getItem());
            OreDictionary.registerOre((String)"oreEmerald", (ItemStack)EnumOre.DARK_EMERALD.getItem());
            OreDictionary.registerOre((String)"oreLapis", (ItemStack)EnumOre.DARK_LAPIS.getItem());
            OreDictionary.registerOre((String)"oreFirestone", (ItemStack)EnumOre.FIRESTONE.getItem());
        }
    }

    public BlockOre(int renderId) {
        super(Material.field_151576_e);
        this.renderType = renderId;
        this.func_149663_c("railcraft.ore");
        this.func_149752_b(5.0f);
        this.func_149711_c(3.0f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149647_a(CreativePlugin.RAILCRAFT_TAB);
    }

    public int func_149645_b() {
        return this.renderType;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumOre ore : EnumOre.values()) {
            list.add(ore.getItem());
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return EnumOre.fromMeta(meta).getItem();
    }

    public void func_149690_a(World world, int x, int y, int z, int par5, float par6, int par7) {
        super.func_149690_a(world, x, y, z, par5, par6, par7);
        int xp = MathHelper.func_76136_a((Random)world.field_73012_v, (int)2, (int)5);
        this.func_149657_c(world, x, y, z, xp);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        switch (EnumOre.fromMeta(meta)) {
            case SULFUR: {
                int qty = 2 + this.rand.nextInt(4) + this.rand.nextInt(fortune + 1);
                drops.add(ItemDust.getDust(ItemDust.EnumDust.SULFUR, qty));
                return drops;
            }
            case SALTPETER: {
                int qty = 1 + this.rand.nextInt(2) + this.rand.nextInt(fortune + 1);
                drops.add(ItemDust.getDust(ItemDust.EnumDust.SALTPETER, qty));
                return drops;
            }
            case DARK_DIAMOND: {
                int bonus = this.rand.nextInt(fortune + 2) - 1;
                if (bonus < 0) {
                    bonus = 0;
                }
                int qty = 1 * (bonus + 1);
                drops.add(new ItemStack(Items.field_151045_i, qty));
                return drops;
            }
            case DARK_EMERALD: {
                int bonus = this.rand.nextInt(fortune + 2) - 1;
                if (bonus < 0) {
                    bonus = 0;
                }
                int qty = 1 * (bonus + 1);
                drops.add(new ItemStack(Items.field_151166_bC, qty));
                return drops;
            }
            case DARK_LAPIS: {
                int bonus = this.rand.nextInt(fortune + 2) - 1;
                if (bonus < 0) {
                    bonus = 0;
                }
                int qty = (4 + this.rand.nextInt(5)) * (bonus + 1);
                drops.add(new ItemStack(Items.field_151100_aR, qty, 4));
                return drops;
            }
        }
        return super.getDrops(world, x, y, z, meta, fortune);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return true;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        for (EnumOre ore : EnumOre.VALUES) {
            ore.setTexture(iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(ore.getTag())));
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        if (renderPass == 0) {
            switch (EnumOre.fromMeta(meta)) {
                case SALTPETER: {
                    return Blocks.field_150322_A.func_149691_a(ForgeDirection.DOWN.ordinal(), 0);
                }
                case FIRESTONE: {
                    return Blocks.field_150424_aL.func_149691_a(0, 0);
                }
                case DARK_DIAMOND: 
                case DARK_EMERALD: 
                case DARK_LAPIS: {
                    IIcon icon = EnumCube.ABYSSAL_STONE.getIcon();
                    if (icon == null) break;
                    return icon;
                }
            }
            return Blocks.field_150348_b.func_149691_a(side, 0);
        }
        return EnumOre.fromMeta(meta).getTexture(side);
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addHitEffects(worldObj, instance, target, effectRenderer, callback);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addDestroyEffects(worldObj, instance, x, y, z, meta, effectRenderer, callback);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (EnumOre.FIRESTONE.ordinal() == meta) {
            return 15;
        }
        return super.getLightValue(world, x, y, z);
    }

    static {
        callback = new ParticleCallback();
    }

    private static class ParticleCallback
    implements ParticleHelperCallback {
        private ParticleCallback() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addHitEffects(EntityDiggingFX fx, World world, int x, int y, int z, int meta) {
            this.setTexture(fx, world, x, y, z, meta);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addDestroyEffects(EntityDiggingFX fx, World world, int x, int y, int z, int meta) {
            this.setTexture(fx, world, x, y, z, meta);
        }

        @SideOnly(value=Side.CLIENT)
        private void setTexture(EntityDiggingFX fx, World world, int x, int y, int z, int meta) {
            renderPass = 0;
            fx.func_110125_a(instance.func_149691_a(0, meta));
        }
    }
}

