/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.ITankTile;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.IronTank;
import mods.railcraft.common.blocks.machine.beta.MetalTank;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.slots.SlotLiquidContainer;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.misc.EnumColor;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileTankBase
extends TileMultiBlock
implements ITankTile {
    public static final int CAPACITY_PER_BLOCK_IRON = 16000;
    public static final int CAPACITY_PER_BLOCK_STEEL = 32000;
    private static final MetalTank IRON_TANK = new IronTank();
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    protected final StandardTank tank = new StandardTank(64000, this);
    protected final TankManager tankManager = new TankManager();
    private static final List<MultiBlockPattern> patterns = TileTankBase.buildPatterns();
    private final StandaloneInventory inv;
    private EnumColor color = EnumColor.WHITE;

    public static void placeIronTank(World world, int x, int y, int z, int patternIndex, FluidStack fluid) {
        MultiBlockPattern pattern = patterns.get(patternIndex);
        HashMap<Character, Integer> blockMapping = new HashMap<Character, Integer>();
        blockMapping.put(Character.valueOf('B'), EnumMachineBeta.TANK_IRON_WALL.ordinal());
        blockMapping.put(Character.valueOf('W'), EnumMachineBeta.TANK_IRON_GAUGE.ordinal());
        TileEntity tile = pattern.placeStructure(world, x, y, z, RailcraftBlocks.getBlockMachineBeta(), blockMapping);
        if (tile instanceof TileTankBase) {
            TileTankBase master = (TileTankBase)tile;
            master.tank.setFluid(fluid);
        }
    }

    public static void placeSteelTank(World world, int x, int y, int z, int patternIndex, FluidStack fluid) {
        MultiBlockPattern pattern = patterns.get(patternIndex);
        HashMap<Character, Integer> blockMapping = new HashMap<Character, Integer>();
        blockMapping.put(Character.valueOf('B'), EnumMachineBeta.TANK_STEEL_WALL.ordinal());
        blockMapping.put(Character.valueOf('W'), EnumMachineBeta.TANK_STEEL_GAUGE.ordinal());
        TileEntity tile = pattern.placeStructure(world, x, y, z, RailcraftBlocks.getBlockMachineBeta(), blockMapping);
        if (tile instanceof TileTankBase) {
            TileTankBase master = (TileTankBase)tile;
            master.tank.setFluid(fluid);
        }
    }

    protected TileTankBase() {
        super(patterns);
        this.inv = new StandaloneInventory(2, "gui.tank.iron", this);
        this.tankManager.add(this.tank);
    }

    public MetalTank getTankType() {
        return IRON_TANK;
    }

    @Override
    public IInventory getInventory() {
        return this.inv;
    }

    @Override
    public Slot getInputSlot(IInventory inv, int slotNum, int x, int y) {
        return new SlotLiquidContainer(inv, slotNum, x, y);
    }

    @Override
    public float getResistance(Entity exploder) {
        return this.getTankType().getResistance(exploder);
    }

    @Override
    protected int getMaxRecursionDepth() {
        return 500;
    }

    @Override
    public String getTitle() {
        return this.getTankType().getTitle();
    }

    @Override
    public void initFromItem(ItemStack stack) {
        super.initFromItem(stack);
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("color")) {
            this.recolourBlock(15 - nbt.func_74771_c("color"));
        }
    }

    @Override
    public boolean canSilkHarvest(EntityPlayer player) {
        return true;
    }

    @Override
    public ArrayList<ItemStack> getDrops(int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack drop = this.getMachineType().getItem();
        NBTTagCompound nbt = InvTools.getItemData(drop);
        nbt.func_74774_a("color", (byte)EnumColor.WHITE.ordinal());
        items.add(drop);
        return items;
    }

    @Override
    public ArrayList<ItemStack> getBlockDroppedSilkTouch(int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack drop = this.getMachineType().getItem();
        NBTTagCompound nbt = InvTools.getItemData(drop);
        nbt.func_74774_a("color", (byte)this.color.ordinal());
        items.add(drop);
        return items;
    }

    @Override
    public boolean recolourBlock(int cID) {
        EnumColor c = EnumColor.fromId(15 - cID);
        if (this.color != c) {
            this.color = c;
            this.markBlockForUpdate();
            return true;
        }
        return false;
    }

    @Override
    public int colorMultiplier() {
        return this.color.getHexColor();
    }

    @Override
    protected boolean isStructureTile(TileEntity tile) {
        return tile instanceof TileTankBase;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        ItemStack current = player.func_71045_bC();
        if (Game.isHost(this.field_145850_b) ? this.isStructureValid() && FluidHelper.handleRightClick(this.getTankManager(), ForgeDirection.getOrientation((int)side), player, true, true) : FluidHelper.isContainer(current)) {
            return true;
        }
        if (current != null && current.func_77973_b() == Items.field_151124_az) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.TANK, player, this.field_145850_b, mBlock.field_145851_c, mBlock.field_145848_d, mBlock.field_145849_e);
            return true;
        }
        return false;
    }

    @Override
    public TankManager getTankManager() {
        TileTankBase mBlock = (TileTankBase)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    @Override
    public StandardTank getTank() {
        TileTankBase mBlock = (TileTankBase)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager.get(0);
        }
        return null;
    }

    public int getCapacityPerBlock() {
        return 16000;
    }

    @Override
    protected void onPatternLock(MultiBlockPattern pattern) {
        if (this.isMaster) {
            int capacity = (pattern.getPatternWidthX() - 2) * (pattern.getPatternHeight() - pattern.getMasterOffsetY() * 2) * (pattern.getPatternWidthZ() - 2) * this.getCapacityPerBlock();
            this.tankManager.setCapacity(0, capacity);
        }
    }

    @Override
    protected void onMasterChanged() {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            tMan.get(0).setFluid(null);
        }
    }

    @Override
    protected boolean isMapPositionValid(int x, int y, int z, char mapPos) {
        switch (mapPos) {
            case 'O': {
                Block block = WorldPlugin.getBlock((IBlockAccess)this.field_145850_b, x, y, z);
                if (block == this.func_145838_q()) {
                    int meta = this.field_145850_b.func_72805_g(x, y, z);
                    if (this.getTankType().isTankBlock(meta)) {
                        return false;
                    }
                }
                return true;
            }
            case 'W': {
                Block block = WorldPlugin.getBlock((IBlockAccess)this.field_145850_b, x, y, z);
                if (block != this.func_145838_q()) {
                    return false;
                }
                int meta = this.field_145850_b.func_72805_g(x, y, z);
                return this.getTankType().isTankBlock(meta);
            }
            case 'B': {
                Block block = WorldPlugin.getBlock((IBlockAccess)this.field_145850_b, x, y, z);
                if (block != this.func_145838_q()) {
                    return false;
                }
                int meta = this.field_145850_b.func_72805_g(x, y, z);
                return this.getTankType().isWallBlock(meta);
            }
            case 'M': 
            case 'T': {
                Block block = WorldPlugin.getBlock((IBlockAccess)this.field_145850_b, x, y, z);
                if (block != this.func_145838_q()) {
                    return false;
                }
                int meta = this.field_145850_b.func_72805_g(x, y, z);
                if (!this.getTankType().isTankBlock(meta)) {
                    return false;
                }
                TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
                if (!(tile instanceof TileMultiBlock)) {
                    this.field_145850_b.func_147475_p(x, y, z);
                    return true;
                }
                return !((TileMultiBlock)tile).isStructureValid();
            }
            case 'A': {
                return this.field_145850_b.func_147437_c(x, y, z);
            }
        }
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isHost(this.field_145850_b) && this.isMaster) {
            if (this.clock % 8 == 0) {
                FluidHelper.processContainers(this.tankManager.get(0), this.inv, 0, 1);
            }
            if (this.clock % 128 == 0) {
                this.sendUpdateToClient();
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tankManager.writeTanksToNBT(data);
        this.inv.writeToNBT("inv", data);
        data.func_74774_a("color", (byte)this.color.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tankManager.readTanksFromNBT(data);
        this.inv.readFromNBT("inv", data);
        if (data.func_74764_b("color")) {
            this.color = EnumColor.fromId(data.func_74771_c("color"));
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.color.ordinal());
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        EnumColor c = EnumColor.fromId(data.readByte());
        this.tankManager.readPacketData(data);
        if (this.color != c) {
            this.color = c;
            this.markBlockForUpdate();
        }
    }

    public double func_145833_n() {
        return 32767.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean shouldRenderInPass(int pass) {
        return this.isMaster ? pass == 0 : pass == 1;
    }

    private static List<MultiBlockPattern> buildPatterns() {
        AxisAlignedBB entityCheck;
        char[][][] map;
        int i;
        ArrayList<MultiBlockPattern> pats = new ArrayList<MultiBlockPattern>();
        boolean client = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        int xOffset = 2;
        int yOffset = 0;
        int zOffset = 2;
        char[][] bottom = new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'M', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}};
        char[][] middle = new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'W', 'A', 'W', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}};
        char[][] top = new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'T', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}};
        char[][] border = new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}};
        for (i = 4; i <= 8; ++i) {
            map = TileTankBase.buildMap(i, bottom, middle, top, border);
            entityCheck = AxisAlignedBB.func_72330_a((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)(i - 1), (double)1.0);
            pats.add(TileTankBase.buildPattern(map, xOffset, yOffset, zOffset, entityCheck));
        }
        if (client || RailcraftConfig.getMaxTankSize() >= 5) {
            zOffset = 3;
            xOffset = 3;
            bottom = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'M', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            middle = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'W', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'W', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            top = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'T', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            border = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            for (i = 4; i <= 8; ++i) {
                map = TileTankBase.buildMap(i, bottom, middle, top, border);
                entityCheck = AxisAlignedBB.func_72330_a((double)-1.0, (double)1.0, (double)-1.0, (double)2.0, (double)(i - 1), (double)2.0);
                pats.add(TileTankBase.buildPattern(map, xOffset, yOffset, zOffset, entityCheck));
            }
        }
        if (client || RailcraftConfig.getMaxTankSize() >= 7) {
            zOffset = 4;
            xOffset = 4;
            bottom = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'M', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            middle = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            top = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'T', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            border = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            for (i = 4; i <= 8; ++i) {
                map = TileTankBase.buildMap(i, bottom, middle, top, border);
                entityCheck = AxisAlignedBB.func_72330_a((double)-2.0, (double)1.0, (double)-2.0, (double)3.0, (double)(i - 1), (double)3.0);
                pats.add(TileTankBase.buildPattern(map, xOffset, yOffset, zOffset, entityCheck));
            }
        }
        if (client || RailcraftConfig.getMaxTankSize() >= 9) {
            zOffset = 5;
            xOffset = 5;
            bottom = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'M', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            middle = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            top = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'T', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            border = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            for (i = 4; i <= 8; ++i) {
                map = TileTankBase.buildMap(i, bottom, middle, top, border);
                entityCheck = AxisAlignedBB.func_72330_a((double)-3.0, (double)1.0, (double)-3.0, (double)4.0, (double)(i - 1), (double)4.0);
                pats.add(TileTankBase.buildPattern(map, xOffset, yOffset, zOffset, entityCheck));
            }
        }
        return pats;
    }

    private static MultiBlockPattern buildPattern(char[][][] map, int xOffset, int yOffset, int zOffset, AxisAlignedBB entityCheck) {
        if (!RailcraftConfig.allowTankStacking()) {
            entityCheck.func_72317_d(0.0, 1.0, 0.0);
            yOffset = 1;
        }
        return new MultiBlockPattern(map, xOffset, yOffset, zOffset, entityCheck);
    }

    private static char[][][] buildMap(int height, char[][] bottom, char[][] mid, char[][] top, char[][] border) {
        char[][][] map;
        if (RailcraftConfig.allowTankStacking()) {
            map = new char[height][][];
            map[0] = bottom;
            map[height - 1] = top;
            for (int i = 1; i < height - 1; ++i) {
                map[i] = mid;
            }
        } else {
            map = new char[height + 2][][];
            map[0] = border;
            map[1] = bottom;
            map[height] = top;
            map[height + 1] = border;
            for (int i = 2; i < height; ++i) {
                map[i] = mid;
            }
        }
        return map;
    }
}

