/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.slab;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import mods.railcraft.client.particles.ParticleHelper;
import mods.railcraft.client.sounds.RailcraftSound;
import mods.railcraft.common.blocks.aesthetics.EnumBlockMaterial;
import mods.railcraft.common.blocks.aesthetics.slab.TileSlab;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.sounds.IBlockSoundProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRailcraftSlab
extends BlockContainer
implements IBlockSoundProvider {
    static BlockRailcraftSlab block;
    private final int renderId;
    public static int currentRenderPass;
    public static EnumBlockMaterial textureSlab;

    public static BlockRailcraftSlab getBlock() {
        return block;
    }

    public static ItemStack getItem(EnumBlockMaterial mat) {
        if (block == null) {
            return null;
        }
        return new ItemStack((Block)block, 1, mat.ordinal());
    }

    public static ItemStack getItem(EnumBlockMaterial mat, int qty) {
        if (block == null) {
            return null;
        }
        return new ItemStack((Block)block, qty, mat.ordinal());
    }

    public static String getTag(EnumBlockMaterial mat) {
        return "railcraft.slab." + mat.name().replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    public static boolean isEnabled(EnumBlockMaterial mat) {
        return ModuleManager.isModuleLoaded(ModuleManager.Module.STRUCTURES) && RailcraftConfig.isSubBlockEnabled(BlockRailcraftSlab.getTag(mat)) && BlockRailcraftSlab.getBlock() != null;
    }

    public static EnumBlockMaterial getTopSlab(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSlab) {
            return ((TileSlab)tile).getTopSlab();
        }
        return null;
    }

    public static EnumBlockMaterial getBottomSlab(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSlab) {
            return ((TileSlab)tile).getBottomSlab();
        }
        return null;
    }

    public static TileSlab getSlabTile(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSlab) {
            return (TileSlab)tile;
        }
        return null;
    }

    protected BlockRailcraftSlab(int renderId) {
        super(Material.field_151576_e);
        this.renderId = renderId;
        this.func_149672_a(RailcraftSound.getInstance());
        this.func_149647_a(CreativePlugin.RAILCRAFT_TAB);
        this.field_149783_u = true;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        EnumBlockMaterial slab;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSlab && (slab = ((TileSlab)tile).getUpmostSlab()) != null) {
            return new ItemStack((Block)this, 1, slab.ordinal());
        }
        return null;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumBlockMaterial mat : EnumBlockMaterial.creativeList) {
            if (!BlockRailcraftSlab.isEnabled(mat)) continue;
            list.add(BlockRailcraftSlab.getItem(mat));
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int i, int j, int k, int meta, int fortune) {
        TileEntity tile = world.func_147438_o(i, j, k);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (tile instanceof TileSlab) {
            EnumBlockMaterial top = ((TileSlab)tile).getTopSlab();
            EnumBlockMaterial bottom = ((TileSlab)tile).getBottomSlab();
            if (top != null) {
                items.add(new ItemStack((Block)this, 1, top.ordinal()));
            }
            if (bottom != null) {
                items.add(new ItemStack((Block)this, 1, bottom.ordinal()));
            }
        }
        return items;
    }

    public void func_149636_a(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71064_a(StatList.field_75934_C[BlockRailcraftSlab.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
        if (Game.isHost(world) && !player.field_71075_bZ.field_75098_d) {
            this.func_149697_b(world, x, y, z, 0, 0);
        }
        return world.func_147468_f(x, y, z);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSlab) {
            EnumBlockMaterial top = ((TileSlab)tile).getTopSlab();
            EnumBlockMaterial bottom = ((TileSlab)tile).getBottomSlab();
            float hardness = 0.0f;
            if (top != null) {
                hardness += top.getBlockHardness(world, x, y, z);
            }
            if (bottom != null) {
                hardness += bottom.getBlockHardness(world, x, y, z);
            }
            if (top != null && bottom != null) {
                hardness /= 2.0f;
            }
            return hardness;
        }
        return super.func_149712_f(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSlab) {
            EnumBlockMaterial top = ((TileSlab)tile).getTopSlab();
            EnumBlockMaterial bottom = ((TileSlab)tile).getBottomSlab();
            float resist = 0.0f;
            if (top != null) {
                resist += top.getExplosionResistance(entity);
            }
            if (bottom != null) {
                resist += bottom.getExplosionResistance(entity);
            }
            if (top != null && bottom != null) {
                resist /= 2.0f;
            }
            return resist;
        }
        return super.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public int func_149645_b() {
        return this.renderId;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        currentRenderPass = pass;
        return pass == 0 || pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return EnumBlockMaterial.fromOrdinal(meta).getIcon(side);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (textureSlab != null) {
            return textureSlab.getIcon(side);
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSlab) {
            return ((TileSlab)tile).getTexture(side);
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addHitEffects(worldObj, (Block)block, target, effectRenderer, null);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addDestroyEffects(worldObj, (Block)block, x, y, z, meta, effectRenderer, null);
    }

    @Override
    public Block.SoundType getSound(World world, int x, int y, int z) {
        EnumBlockMaterial slab;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSlab && (slab = ((TileSlab)tile).getUpmostSlab()) != null) {
            return slab.getSound();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileSlab slab = BlockRailcraftSlab.getSlabTile(world, x, y, z);
        if (slab != null) {
            if (slab.isDoubleSlab()) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else if (slab.isBottomSlab()) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            } else if (slab.isTopSlab()) {
                this.func_149676_a(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        int i1 = x + Facing.field_71586_b[Facing.field_71588_a[side]];
        int j1 = y + Facing.field_71587_c[Facing.field_71588_a[side]];
        int k1 = z + Facing.field_71585_d[Facing.field_71588_a[side]];
        TileEntity tile = world.func_147438_o(i1, j1, k1);
        if (tile instanceof TileSlab) {
            TileSlab otherSlab;
            TileSlab slab = (TileSlab)tile;
            EnumBlockMaterial top = slab.getTopSlab();
            EnumBlockMaterial bottom = slab.getBottomSlab();
            if (slab.isDoubleSlab()) {
                return super.func_149646_a(world, x, y, z, side);
            }
            if (side != 1 && side != 0 && !super.func_149646_a(world, x, y, z, side)) {
                return false;
            }
            if (top != null) {
                if (side == 0) {
                    return true;
                }
                if (side == 1 && super.func_149646_a(world, x, y, z, side)) {
                    return true;
                }
                if (WorldPlugin.getBlock(world, x, y, z) != this) {
                    return true;
                }
                otherSlab = BlockRailcraftSlab.getSlabTile(world, x, y, z);
                if (otherSlab != null) {
                    if (slab.isDoubleSlab()) {
                        return false;
                    }
                    return otherSlab.isBottomSlab() || otherSlab.isTopSlab() && otherSlab.getTopSlab().isTransparent();
                }
            }
            if (bottom != null) {
                if (side == 1) {
                    return true;
                }
                if (side == 0 && super.func_149646_a(world, x, y, z, side)) {
                    return true;
                }
                if (WorldPlugin.getBlock(world, x, y, z) != this) {
                    return true;
                }
                otherSlab = BlockRailcraftSlab.getSlabTile(world, x, y, z);
                if (otherSlab != null) {
                    if (slab.isDoubleSlab()) {
                        return false;
                    }
                    return otherSlab.isTopSlab() || otherSlab.isBottomSlab() && otherSlab.getBottomSlab().isTransparent();
                }
            }
        }
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileSlab tile = BlockRailcraftSlab.getSlabTile(world, x, y, z);
        if (tile != null) {
            if (tile.isDoubleSlab()) {
                return true;
            }
            if (side == ForgeDirection.DOWN && tile.isBottomSlab()) {
                return true;
            }
            if (side == ForgeDirection.UP && tile.isTopSlab()) {
                return true;
            }
        }
        return false;
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        TileSlab tile = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z);
        if (tile != null) {
            if (tile.isDoubleSlab()) {
                return true;
            }
            if (tile.isTopSlab()) {
                return true;
            }
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileSlab();
    }

    static {
        textureSlab = null;
    }
}

